/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.jca;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.ra.ActiveMQActivationSpec;
import org.apache.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.activemq.ra.ActiveMQResourceAdapter;
import org.apache.geronimo.connector.BootstrapContextImpl;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.servicemix.jbi.container.SpringJBIContainer;
import org.apache.servicemix.jbi.event.ComponentAdapter;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointAdapter;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.flow.AbstractFlow;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.jencks.JCAConnector;
import org.jencks.SingletonEndpointFactory;
import org.jencks.factory.ConnectionManagerFactoryBean;
import org.springframework.context.ApplicationContext;

public class JCAFlow
extends AbstractFlow
implements MessageListener {
    private static final String INBOUND_PREFIX = "org.apache.servicemix.jca.";
    private String jmsURL = "tcp://localhost:61616";
    private String userName;
    private String password;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private String broadcastDestinationName = "org.apache.servicemix.JCAFlow";
    private Topic broadcastTopic;
    private Map connectorMap = new ConcurrentHashMap();
    private AtomicBoolean started = new AtomicBoolean(false);
    private Set subscriberSet = new CopyOnWriteArraySet();
    private TransactionContextManager transactionContextManager;
    private ConnectionManager connectionManager;
    private BootstrapContext bootstrapContext;
    private ResourceAdapter resourceAdapter;
    private JCAConnector containerConnector;
    private JCAConnector broadcastConnector;
    private Session broadcastSession;
    private Topic advisoryTopic;
    private MessageConsumer advisoryConsumer;
    private EndpointListener endpointListener;
    private ComponentListener componentListener;

    public String getDescription() {
        return "jca";
    }

    public String getJmsURL() {
        return this.jmsURL;
    }

    public void setJmsURL(String jmsURL) {
        this.jmsURL = jmsURL;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectoFactory) {
        this.connectionFactory = connectoFactory;
    }

    public String getBroadcastDestinationName() {
        return this.broadcastDestinationName;
    }

    public void setBroadcastDestinationName(String broadcastDestinationName) {
        this.broadcastDestinationName = broadcastDestinationName;
    }

    protected ResourceAdapter createResourceAdapter() throws ResourceAdapterInternalException {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setServerUrl(this.jmsURL);
        ra.start(this.getBootstrapContext());
        return ra;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.broker.getContainer().getTransactionManager();
    }

    public void init(Broker broker) throws JBIException {
        this.log.info((Object)(broker.getContainer().getName() + ": Initializing jca flow"));
        super.init(broker);
        this.endpointListener = new EndpointAdapter(){

            public void internalEndpointRegistered(EndpointEvent event) {
                JCAFlow.this.onInternalEndpointRegistered(event, true);
            }

            public void internalEndpointUnregistered(EndpointEvent event) {
                JCAFlow.this.onInternalEndpointUnregistered(event, true);
            }
        };
        broker.getContainer().addListener(this.endpointListener);
        this.componentListener = new ComponentAdapter(){

            public void componentStarted(ComponentEvent event) {
                JCAFlow.this.onComponentStarted(event);
            }

            public void componentStopped(ComponentEvent event) {
                JCAFlow.this.onComponentStopped(event);
            }
        };
        broker.getContainer().addListener(this.componentListener);
        try {
            this.resourceAdapter = this.createResourceAdapter();
            ActiveMQActivationSpec ac = new ActiveMQActivationSpec();
            ac.setDestinationType("javax.jms.Queue");
            ac.setDestination(INBOUND_PREFIX + broker.getContainer().getName());
            this.containerConnector = new JCAConnector();
            this.containerConnector.setBootstrapContext(this.getBootstrapContext());
            this.containerConnector.setActivationSpec((ActivationSpec)ac);
            this.containerConnector.setResourceAdapter(this.resourceAdapter);
            this.containerConnector.setEndpointFactory((MessageEndpointFactory)new SingletonEndpointFactory((MessageListener)this, this.getTransactionManager()));
            this.containerConnector.afterPropertiesSet();
            ActiveMQManagedConnectionFactory mcf = new ActiveMQManagedConnectionFactory();
            mcf.setResourceAdapter(this.resourceAdapter);
            this.connectionFactory = (ConnectionFactory)mcf.createConnectionFactory(this.getConnectionManager());
            this.connection = ((ActiveMQResourceAdapter)this.resourceAdapter).makeConnection();
            this.connection.start();
            this.broadcastTopic = new ActiveMQTopic(this.broadcastDestinationName);
            this.broadcastSession = this.connection.createSession(false, 1);
            this.broadcastTopic = new ActiveMQTopic(this.broadcastDestinationName);
            this.advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)this.broadcastTopic));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize JCAFlow", (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }

    public void start() throws JBIException {
        if (this.started.compareAndSet(false, true)) {
            super.start();
            try {
                ActiveMQActivationSpec ac = new ActiveMQActivationSpec();
                ac.setDestinationType("javax.jms.Topic");
                ac.setDestination(this.broadcastDestinationName);
                this.broadcastConnector = new JCAConnector();
                this.broadcastConnector.setBootstrapContext(this.getBootstrapContext());
                this.broadcastConnector.setActivationSpec((ActivationSpec)ac);
                this.broadcastConnector.setResourceAdapter(this.resourceAdapter);
                this.broadcastConnector.setEndpointFactory((MessageEndpointFactory)new SingletonEndpointFactory(new MessageListener(){

                    public void onMessage(Message message) {
                        try {
                            Serializable obj = ((ObjectMessage)message).getObject();
                            if (obj instanceof EndpointEvent) {
                                EndpointEvent event = (EndpointEvent)obj;
                                String container = ((InternalEndpoint)event.getEndpoint()).getComponentNameSpace().getContainerName();
                                if (!JCAFlow.this.getBroker().getContainer().getName().equals(container)) {
                                    if (event.getEventType() == 0) {
                                        JCAFlow.this.onRemoteEndpointRegistered(event);
                                    } else if (event.getEventType() == 1) {
                                        JCAFlow.this.onRemoteEndpointUnregistered(event);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            JCAFlow.this.log.error((Object)"Error processing incoming broadcast message", (Throwable)e);
                        }
                    }
                }));
                this.broadcastConnector.afterPropertiesSet();
                this.advisoryConsumer = this.broadcastSession.createConsumer((Destination)this.advisoryTopic);
                this.advisoryConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        if (JCAFlow.this.started.get()) {
                            JCAFlow.this.onAdvisoryMessage(((ActiveMQMessage)message).getDataStructure());
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new JBIException("JMSException caught in start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            super.stop();
            try {
                this.advisoryConsumer.close();
            }
            catch (JMSException e) {
                JBIException jbiEx = new JBIException("JMSException caught in stop: " + e.getMessage());
                throw jbiEx;
            }
        }
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        this.stop();
        this.broker.getContainer().removeListener(this.endpointListener);
        this.broker.getContainer().removeListener(this.componentListener);
        while (!this.connectorMap.isEmpty()) {
            JCAConnector connector = (JCAConnector)this.connectorMap.remove(this.connectorMap.keySet().iterator().next());
            try {
                connector.destroy();
            }
            catch (Exception e) {
                this.log.warn((Object)"error closing jca connector", (Throwable)e);
            }
        }
        try {
            this.containerConnector.destroy();
        }
        catch (Exception e) {
            this.log.warn((Object)"error closing jca connector", (Throwable)e);
        }
        try {
            this.broadcastConnector.destroy();
        }
        catch (Exception e) {
            this.log.warn((Object)"error closing jca connector", (Throwable)e);
        }
        this.resourceAdapter.stop();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.log.warn((Object)"error closing JMS Connection", (Throwable)e);
            }
        }
    }

    public int numberInNetwork() {
        return this.subscriberSet.size();
    }

    public boolean canHandle(MessageExchange me) {
        return !this.isTransacted(me) || !this.isSynchronous(me);
    }

    public void onInternalEndpointRegistered(EndpointEvent event, boolean broadcast) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            if (!this.connectorMap.containsKey(key)) {
                ActiveMQActivationSpec ac = new ActiveMQActivationSpec();
                ac.setDestinationType("javax.jms.Queue");
                ac.setDestination(INBOUND_PREFIX + key);
                JCAConnector connector = new JCAConnector();
                connector.setBootstrapContext(this.getBootstrapContext());
                connector.setActivationSpec((ActivationSpec)ac);
                connector.setResourceAdapter(this.resourceAdapter);
                connector.setEndpointFactory((MessageEndpointFactory)new SingletonEndpointFactory((MessageListener)this, this.getTransactionManager()));
                connector.afterPropertiesSet();
                this.connectorMap.put(key, connector);
            }
            if (broadcast) {
                this.log.info((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
                this.sendJmsMessage((Destination)this.broadcastTopic, event, false, false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for " + event.getEndpoint()), (Throwable)e);
        }
    }

    public void onInternalEndpointUnregistered(EndpointEvent event, boolean broadcast) {
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            JCAConnector connector = (JCAConnector)this.connectorMap.remove(key);
            if (connector != null) {
                connector.destroy();
            }
            if (broadcast) {
                this.log.info((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
                this.sendJmsMessage((Destination)this.broadcastTopic, event, false, false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for " + event), (Throwable)e);
        }
    }

    public void onComponentStarted(ComponentEvent event) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = event.getComponent().getName();
            if (!this.connectorMap.containsKey(key)) {
                ActiveMQActivationSpec ac = new ActiveMQActivationSpec();
                ac.setDestinationType("javax.jms.Queue");
                ac.setDestination(INBOUND_PREFIX + key);
                JCAConnector connector = new JCAConnector();
                connector.setBootstrapContext(this.getBootstrapContext());
                connector.setActivationSpec((ActivationSpec)ac);
                connector.setResourceAdapter(this.resourceAdapter);
                connector.setEndpointFactory((MessageEndpointFactory)new SingletonEndpointFactory((MessageListener)this, this.getTransactionManager()));
                connector.afterPropertiesSet();
                this.connectorMap.put(key, connector);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onComponentStopped(ComponentEvent event) {
        try {
            String key = event.getComponent().getName();
            JCAConnector connector = (JCAConnector)this.connectorMap.remove(key);
            if (connector != null) {
                connector.destroy();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onRemoteEndpointRegistered(EndpointEvent event) {
        this.log.info((Object)(this.broker.getContainer().getName() + ": adding remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().registerRemoteEndpoint(event.getEndpoint());
    }

    public void onRemoteEndpointUnregistered(EndpointEvent event) {
        this.log.info((Object)(this.broker.getContainer().getName() + ": removing remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().unregisterRemoteEndpoint(event.getEndpoint());
    }

    protected void doSend(MessageExchangeImpl me) throws MessagingException {
        this.doRouting(me);
    }

    public void doRouting(MessageExchangeImpl me) throws MessagingException {
        try {
            String destination;
            if (me.getRole() == MessageExchange.Role.PROVIDER) {
                destination = me.getDestinationId() == null ? INBOUND_PREFIX + EndpointSupport.getKey(me.getEndpoint()) : (Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.provider.stateless")) && !this.isSynchronous(me) ? INBOUND_PREFIX + me.getDestinationId().getName() : INBOUND_PREFIX + me.getDestinationId().getContainerName());
            } else {
                if (me.getSourceId() == null) {
                    throw new IllegalStateException("No sourceId set on the exchange");
                }
                destination = Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.consumer.stateless")) && !this.isSynchronous(me) ? (me.getProperty("org.apache.servicemix.senderEndpoint") != null ? INBOUND_PREFIX + me.getProperty("org.apache.servicemix.senderEndpoint") : INBOUND_PREFIX + me.getSourceId().getName()) : INBOUND_PREFIX + me.getSourceId().getContainerName();
            }
            if (me.isTransacted()) {
                me.setTxState(1);
            }
            this.sendJmsMessage((Destination)new ActiveMQQueue(destination), me, this.isPersistent(me), me.isTransacted());
        }
        catch (JMSException e) {
            this.log.error((Object)("Failed to send exchange: " + me + " internal JMS Network"), (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
        catch (SystemException e) {
            this.log.error((Object)("Failed to send exchange: " + me + " transaction problem"), (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message != null && this.started.get()) {
                ObjectMessage objMsg = (ObjectMessage)message;
                MessageExchangeImpl me = (MessageExchangeImpl)objMsg.getObject();
                TransactionManager tm = this.getTransactionManager();
                if (tm != null) {
                    me.setTransactionContext(tm.getTransaction());
                }
                if (me.getDestinationId() == null) {
                    ServiceEndpoint se = me.getEndpoint();
                    se = this.broker.getContainer().getRegistry().getInternalEndpoint(se.getServiceName(), se.getEndpointName());
                    me.setEndpoint(se);
                    me.setDestinationId(((InternalEndpoint)se).getComponentNameSpace());
                }
                super.doRouting(me);
            }
        }
        catch (JMSException jmsEx) {
            this.log.error((Object)"Caught an exception unpacking JMS Message: ", (Throwable)jmsEx);
        }
        catch (MessagingException e) {
            this.log.error((Object)"Caught an exception routing ExchangePacket: ", (Throwable)e);
        }
        catch (SystemException e) {
            this.log.error((Object)"Caught an exception acessing transaction context: ", (Throwable)e);
        }
    }

    protected void onAdvisoryMessage(Object obj) {
        if (obj instanceof ConsumerInfo) {
            ConsumerInfo info = (ConsumerInfo)obj;
            this.subscriberSet.add(info.getConsumerId().getConnectionId());
            ServiceEndpoint[] endpoints = this.broker.getContainer().getRegistry().getEndpointsForInterface(null);
            for (int i = 0; i < endpoints.length; ++i) {
                if (!(endpoints[i] instanceof InternalEndpoint) || !((InternalEndpoint)endpoints[i]).isLocal()) continue;
                this.onInternalEndpointRegistered(new EndpointEvent(endpoints[i], 0), true);
            }
        } else if (obj instanceof RemoveInfo) {
            ConsumerId id = (ConsumerId)((RemoveInfo)obj).getObjectId();
            this.subscriberSet.remove(id.getConnectionId());
            this.removeAllPackets(id.getConnectionId());
        }
    }

    private void removeAllPackets(String containerName) {
    }

    public ConnectionManager getConnectionManager() throws Exception {
        if (this.connectionManager == null) {
            ConnectionManagerFactoryBean cmfb = new ConnectionManagerFactoryBean();
            cmfb.setTransactionContextManager(this.getTransactionContextManager());
            cmfb.setPoolingSupport((PoolingSupport)new SinglePool(16, 0, 100, 1, true, true, true));
            cmfb.setTransactionSupport((TransactionSupport)new XATransactions(true, false));
            cmfb.afterPropertiesSet();
            this.connectionManager = (ConnectionManager)cmfb.getObject();
        }
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public TransactionContextManager getTransactionContextManager() {
        Map map;
        ApplicationContext applicationContext;
        if (this.transactionContextManager == null && this.broker != null && this.broker.getContainer() instanceof SpringJBIContainer && (applicationContext = ((SpringJBIContainer)this.broker.getContainer()).getApplicationContext()) != null && (map = applicationContext.getBeansOfType(TransactionContextManager.class)).size() == 1) {
            this.transactionContextManager = (TransactionContextManager)map.values().iterator().next();
        }
        return this.transactionContextManager;
    }

    public void setTransactionContextManager(TransactionContextManager transactionContextManager) {
        this.transactionContextManager = transactionContextManager;
    }

    public BootstrapContext getBootstrapContext() {
        if (this.bootstrapContext == null) {
            GeronimoWorkManager wm = (GeronimoWorkManager)this.broker.getContainer().getWorkManager();
            this.bootstrapContext = new BootstrapContextImpl(wm);
        }
        return this.bootstrapContext;
    }

    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    public String toString() {
        return this.broker.getContainer().getName() + " JCAFlow";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJmsMessage(Destination dest, Serializable object, boolean persistent, boolean transacted) throws JMSException, SystemException {
        TransactionManager tm;
        if (transacted && (tm = (TransactionManager)this.getBroker().getContainer().getTransactionManager()).getStatus() == 1) {
            return;
        }
        Connection connection = this.connectionFactory.createConnection();
        try {
            Session session = connection.createSession(transacted, transacted ? 0 : 1);
            ObjectMessage msg = session.createObjectMessage(object);
            MessageProducer producer = session.createProducer(dest);
            producer.setDeliveryMode(persistent ? 2 : 1);
            producer.send((Message)msg);
        }
        finally {
            connection.close();
        }
    }
}

