/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.jms;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.servicemix.jbi.event.ComponentAdapter;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointAdapter;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.flow.AbstractFlow;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public class JMSFlow
extends AbstractFlow
implements MessageListener {
    private static final String INBOUND_PREFIX = "org.apache.servicemix.jms.";
    private String jmsURL = "peer://org.apache.servicemix?persistent=false";
    private String userName;
    private String password;
    private ActiveMQConnectionFactory connectionFactory;
    private ActiveMQConnection connection;
    private String broadcastDestinationName = "org.apache.servicemix.JMSFlow";
    private MessageProducer queueProducer;
    private MessageProducer topicProducer;
    private Topic broadcastTopic;
    private Session broadcastSession;
    private MessageConsumer broadcastConsumer;
    private Session inboundSession;
    private MessageConsumer advisoryConsumer;
    private Set subscriberSet = new CopyOnWriteArraySet();
    private Map consumerMap = new ConcurrentHashMap();
    private AtomicBoolean started = new AtomicBoolean(false);
    private EndpointListener endpointListener;
    private ComponentListener componentListener;

    public String getDescription() {
        return "jms";
    }

    public String getJmsURL() {
        return this.jmsURL;
    }

    public void setJmsURL(String jmsURL) {
        this.jmsURL = jmsURL;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getBroadcastDestinationName() {
        return this.broadcastDestinationName;
    }

    public void setBroadcastDestinationName(String broadcastDestinationName) {
        this.broadcastDestinationName = broadcastDestinationName;
    }

    public boolean canHandle(MessageExchange me) {
        return !this.isTransacted(me);
    }

    public void init(Broker broker) throws JBIException {
        this.log.info((Object)(broker.getContainer().getName() + ": Initializing jms flow"));
        super.init(broker);
        this.endpointListener = new EndpointAdapter(){

            public void internalEndpointRegistered(EndpointEvent event) {
                JMSFlow.this.onInternalEndpointRegistered(event, true);
            }

            public void internalEndpointUnregistered(EndpointEvent event) {
                JMSFlow.this.onInternalEndpointUnregistered(event, true);
            }
        };
        broker.getContainer().addListener(this.endpointListener);
        this.componentListener = new ComponentAdapter(){

            public void componentStarted(ComponentEvent event) {
                JMSFlow.this.onComponentStarted(event);
            }

            public void componentStopped(ComponentEvent event) {
                JMSFlow.this.onComponentStopped(event);
            }
        };
        broker.getContainer().addListener(this.componentListener);
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = this.jmsURL != null ? new ActiveMQConnectionFactory(this.jmsURL) : new ActiveMQConnectionFactory();
            }
            this.connection = this.userName != null ? (ActiveMQConnection)this.connectionFactory.createConnection(this.userName, this.password) : (ActiveMQConnection)this.connectionFactory.createConnection();
            this.connection.setClientID(broker.getContainer().getName());
            this.connection.start();
            this.inboundSession = this.connection.createSession(false, 1);
            Queue queue = this.inboundSession.createQueue(INBOUND_PREFIX + broker.getContainer().getName());
            MessageConsumer inboundQueue = this.inboundSession.createConsumer((Destination)queue);
            inboundQueue.setMessageListener((MessageListener)this);
            this.queueProducer = this.inboundSession.createProducer(null);
            this.broadcastSession = this.connection.createSession(false, 1);
            this.broadcastTopic = this.broadcastSession.createTopic(this.broadcastDestinationName);
            this.topicProducer = this.broadcastSession.createProducer((Destination)this.broadcastTopic);
            this.topicProducer.setDeliveryMode(1);
        }
        catch (JMSException e) {
            this.log.error((Object)"Failed to initialize JMSFlow", (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }

    public void start() throws JBIException {
        if (this.started.compareAndSet(false, true)) {
            this.log.info((Object)(this.broker.getContainer().getName() + ": Starting jms flow"));
            super.start();
            try {
                this.broadcastConsumer = this.broadcastSession.createConsumer((Destination)this.broadcastTopic, null, true);
                this.broadcastConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        try {
                            Serializable obj = ((ObjectMessage)message).getObject();
                            if (obj instanceof EndpointEvent) {
                                EndpointEvent event = (EndpointEvent)obj;
                                String container = ((InternalEndpoint)event.getEndpoint()).getComponentNameSpace().getContainerName();
                                if (!JMSFlow.this.getBroker().getContainer().getName().equals(container)) {
                                    if (event.getEventType() == 0) {
                                        JMSFlow.this.onRemoteEndpointRegistered(event);
                                    } else if (event.getEventType() == 1) {
                                        JMSFlow.this.onRemoteEndpointUnregistered(event);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            JMSFlow.this.log.error((Object)"Error processing incoming broadcast message", (Throwable)e);
                        }
                    }
                });
                ActiveMQTopic advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)this.broadcastTopic));
                this.advisoryConsumer = this.broadcastSession.createConsumer((Destination)advisoryTopic);
                this.advisoryConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        if (JMSFlow.this.started.get()) {
                            JMSFlow.this.onAdvisoryMessage(((ActiveMQMessage)message).getDataStructure());
                        }
                    }
                });
                Iterator it = this.broker.getContainer().getRegistry().getComponents().iterator();
                while (it.hasNext()) {
                    ComponentMBeanImpl cmp = (ComponentMBeanImpl)it.next();
                    if (!cmp.isStarted()) continue;
                    this.onComponentStarted(new ComponentEvent(cmp, 1));
                }
                ServiceEndpoint[] endpoints = this.broker.getContainer().getRegistry().getEndpointsForInterface(null);
                for (int i = 0; i < endpoints.length; ++i) {
                    if (!(endpoints[i] instanceof InternalEndpoint) || !((InternalEndpoint)endpoints[i]).isLocal()) continue;
                    this.onInternalEndpointRegistered(new EndpointEvent(endpoints[i], 0), false);
                }
            }
            catch (JMSException e) {
                JBIException jbiEx = new JBIException("JMSException caught in start: " + e.getMessage());
                throw jbiEx;
            }
        }
    }

    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            this.log.info((Object)(this.broker.getContainer().getName() + ": Stopping jms flow"));
            super.stop();
            Iterator it = this.subscriberSet.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                this.removeAllPackets(id);
            }
            this.subscriberSet.clear();
            try {
                this.advisoryConsumer.close();
                this.broadcastConsumer.close();
            }
            catch (JMSException e) {
                JBIException jbiEx = new JBIException("JMSException caught in stop: " + e.getMessage());
                throw jbiEx;
            }
        }
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        this.stop();
        this.broker.getContainer().removeListener(this.endpointListener);
        this.broker.getContainer().removeListener(this.componentListener);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.log.warn((Object)"Error closing JMS Connection", (Throwable)e);
            }
        }
    }

    public int numberInNetwork() {
        return this.subscriberSet.size();
    }

    public void onInternalEndpointRegistered(EndpointEvent event, boolean broadcast) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            if (!this.consumerMap.containsKey(key)) {
                Queue queue = this.inboundSession.createQueue(INBOUND_PREFIX + key);
                MessageConsumer consumer = this.inboundSession.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)this);
                this.consumerMap.put(key, consumer);
            }
            if (broadcast) {
                this.log.info((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
                ObjectMessage msg = this.broadcastSession.createObjectMessage((Serializable)event);
                this.topicProducer.send((Message)msg);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for " + event.getEndpoint()), (Throwable)e);
        }
    }

    public void onInternalEndpointUnregistered(EndpointEvent event, boolean broadcast) {
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            MessageConsumer consumer = (MessageConsumer)this.consumerMap.remove(key);
            if (consumer != null) {
                consumer.close();
            }
            if (broadcast) {
                ObjectMessage msg = this.broadcastSession.createObjectMessage((Serializable)event);
                this.log.info((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
                this.topicProducer.send((Message)msg);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for " + event), (Throwable)e);
        }
    }

    public void onComponentStarted(ComponentEvent event) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = event.getComponent().getName();
            if (!this.consumerMap.containsKey(key)) {
                Queue queue = this.inboundSession.createQueue(INBOUND_PREFIX + key);
                MessageConsumer consumer = this.inboundSession.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)this);
                this.consumerMap.put(key, consumer);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onComponentStopped(ComponentEvent event) {
        try {
            String key = event.getComponent().getName();
            MessageConsumer consumer = (MessageConsumer)this.consumerMap.remove(key);
            if (consumer != null) {
                consumer.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onRemoteEndpointRegistered(EndpointEvent event) {
        this.log.info((Object)(this.broker.getContainer().getName() + ": adding remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().registerRemoteEndpoint(event.getEndpoint());
    }

    public void onRemoteEndpointUnregistered(EndpointEvent event) {
        this.log.info((Object)(this.broker.getContainer().getName() + ": removing remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().unregisterRemoteEndpoint(event.getEndpoint());
    }

    protected void doSend(MessageExchangeImpl me) throws MessagingException {
        this.doRouting(me);
    }

    public void doRouting(MessageExchangeImpl me) throws MessagingException {
        try {
            String destination;
            if (me.getRole() == MessageExchange.Role.PROVIDER) {
                destination = me.getDestinationId() == null ? INBOUND_PREFIX + EndpointSupport.getKey(me.getEndpoint()) : (Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.provider.stateless")) && !this.isSynchronous(me) ? INBOUND_PREFIX + me.getDestinationId().getName() : INBOUND_PREFIX + me.getDestinationId().getContainerName());
            } else {
                if (me.getSourceId() == null) {
                    throw new IllegalStateException("No sourceId set on the exchange");
                }
                destination = Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.consumer.stateless")) && !this.isSynchronous(me) ? (me.getProperty("org.apache.servicemix.senderEndpoint") != null ? INBOUND_PREFIX + me.getProperty("org.apache.servicemix.senderEndpoint") : INBOUND_PREFIX + me.getSourceId().getName()) : INBOUND_PREFIX + me.getSourceId().getContainerName();
            }
            Queue queue = this.inboundSession.createQueue(destination);
            ObjectMessage msg = this.inboundSession.createObjectMessage((Serializable)me);
            this.queueProducer.send((Destination)queue, (Message)msg);
        }
        catch (JMSException e) {
            this.log.error((Object)("Failed to send exchange: " + me + " internal JMS Network"), (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message != null && this.started.get()) {
                ObjectMessage objMsg = (ObjectMessage)message;
                final MessageExchangeImpl me = (MessageExchangeImpl)objMsg.getObject();
                this.broker.getContainer().getWorkManager().scheduleWork(new Work(){

                    public void release() {
                    }

                    public void run() {
                        try {
                            if (me.getDestinationId() == null) {
                                ServiceEndpoint se = me.getEndpoint();
                                se = JMSFlow.this.broker.getContainer().getRegistry().getInternalEndpoint(se.getServiceName(), se.getEndpointName());
                                me.setEndpoint(se);
                                me.setDestinationId(((InternalEndpoint)se).getComponentNameSpace());
                            }
                            JMSFlow.super.doRouting(me);
                        }
                        catch (Throwable e) {
                            JMSFlow.this.log.error((Object)"Caught an exception routing ExchangePacket: ", e);
                        }
                    }
                });
            }
        }
        catch (JMSException jmsEx) {
            this.log.error((Object)"Caught an exception unpacking JMS Message: ", (Throwable)jmsEx);
        }
        catch (WorkException e) {
            this.log.error((Object)"Caught an exception routing ExchangePacket: ", (Throwable)e);
        }
    }

    protected void onAdvisoryMessage(Object obj) {
        if (obj instanceof ConsumerInfo) {
            ConsumerInfo info = (ConsumerInfo)obj;
            this.subscriberSet.add(info.getConsumerId().getConnectionId());
            ServiceEndpoint[] endpoints = this.broker.getContainer().getRegistry().getEndpointsForInterface(null);
            for (int i = 0; i < endpoints.length; ++i) {
                if (!(endpoints[i] instanceof InternalEndpoint) || !((InternalEndpoint)endpoints[i]).isLocal()) continue;
                this.onInternalEndpointRegistered(new EndpointEvent(endpoints[i], 0), true);
            }
        } else if (obj instanceof RemoveInfo) {
            ConsumerId id = (ConsumerId)((RemoveInfo)obj).getObjectId();
            this.subscriberSet.remove(id.getConnectionId());
            this.removeAllPackets(id.getConnectionId());
        }
    }

    private void removeAllPackets(String containerName) {
    }
}

