/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security.acl.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.security.acl.AuthorizationMap;
import org.apache.servicemix.jbi.security.acl.impl.AuthorizationEntry;

public class DefaultAuthorizationMap
implements AuthorizationMap {
    private AuthorizationEntry defaultEntry;
    private List authorizationEntries;

    public DefaultAuthorizationMap() {
    }

    public DefaultAuthorizationMap(List authorizationEntries) {
        this.authorizationEntries = authorizationEntries;
    }

    public List getAuthorizationEntries() {
        return this.authorizationEntries;
    }

    public void setAuthorizationEntries(List authorizationEntries) {
        this.authorizationEntries = authorizationEntries;
    }

    public AuthorizationEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(AuthorizationEntry defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    public Set getAcls(ServiceEndpoint endpoint) {
        HashSet<AuthorizationEntry> acls = new HashSet<AuthorizationEntry>();
        if (this.defaultEntry != null) {
            acls.add(this.defaultEntry);
        }
        Iterator iter = this.authorizationEntries.iterator();
        while (iter.hasNext()) {
            AuthorizationEntry entry = (AuthorizationEntry)iter.next();
            if (!this.match(entry, endpoint)) continue;
            if ("add".equalsIgnoreCase(entry.getType())) {
                acls.addAll(entry.getAcls());
                continue;
            }
            if ("set".equalsIgnoreCase(entry.getType())) {
                acls.clear();
                acls.addAll(entry.getAcls());
                continue;
            }
            if (!"rem".equalsIgnoreCase(entry.getType())) continue;
            acls.removeAll(entry.getAcls());
        }
        return acls;
    }

    protected boolean match(AuthorizationEntry entry, ServiceEndpoint endpoint) {
        return this.match(entry.getService(), endpoint.getServiceName()) && this.match(entry.getEndpoint(), endpoint.getEndpointName());
    }

    private boolean match(QName acl, QName target) {
        return this.match(acl.getNamespaceURI(), target.getNamespaceURI()) && this.match(acl.getLocalPart(), target.getLocalPart());
    }

    private boolean match(String acl, String target) {
        return acl == null || acl.equals("*") || Pattern.matches(acl, target);
    }
}

