/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.util;

import java.util.ArrayList;
import java.util.List;

public class BoundedLinkedQueue {
    protected LinkedNode head_;
    protected LinkedNode last_;
    protected final Object putGuard_ = new Object();
    protected final Object takeGuard_ = new Object();
    protected int capacity_;
    protected int putSidePutPermits_;
    protected int takeSidePutPermits_ = 0;
    protected volatile boolean closed;

    public BoundedLinkedQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        this.putSidePutPermits_ = capacity;
        this.last_ = this.head_ = new LinkedNode(null);
    }

    public BoundedLinkedQueue() {
        this(1024);
    }

    protected final int reconcilePutPermits() {
        this.putSidePutPermits_ += this.takeSidePutPermits_;
        this.takeSidePutPermits_ = 0;
        return this.putSidePutPermits_;
    }

    public synchronized int capacity() {
        return this.capacity_;
    }

    public synchronized int size() {
        return this.capacity_ - (this.takeSidePutPermits_ + this.putSidePutPermits_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int newCapacity) {
        if (newCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.putGuard_;
        synchronized (object) {
            BoundedLinkedQueue boundedLinkedQueue = this;
            synchronized (boundedLinkedQueue) {
                this.takeSidePutPermits_ += newCapacity - this.capacity_;
                this.capacity_ = newCapacity;
                this.reconcilePutPermits();
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object extract() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.head_.next;
            if (first != null) {
                x = first.value;
                first.value = null;
                this.head_ = first;
                ++this.takeSidePutPermits_;
                this.notify();
            }
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        if (this.closed) {
            throw new IllegalStateException("Channel is closed");
        }
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            LinkedNode first = this.head_.next;
            if (first != null) {
                return first.value;
            }
            return null;
        }
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.closed) {
            throw new IllegalStateException("Channel is closed");
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.takeGuard_;
        synchronized (object) {
            try {
                while (true) {
                    if ((x = this.extract()) != null) {
                        return x;
                    }
                    if (this.closed) {
                        throw new IllegalStateException("Channel is closed");
                    }
                    this.takeGuard_.wait();
                }
            }
            catch (InterruptedException ex) {
                this.takeGuard_.notify();
                throw ex;
            }
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.closed) {
            throw new IllegalStateException("Channel is closed");
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.takeGuard_;
        synchronized (object) {
            try {
                long start;
                long waitTime = msecs;
                long l = start = msecs <= 0L ? 0L : System.currentTimeMillis();
                while (true) {
                    if ((x = this.extract()) != null || waitTime <= 0L) {
                        return x;
                    }
                    if (this.closed) {
                        throw new IllegalStateException("Channel is closed");
                    }
                    this.takeGuard_.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
            }
            catch (InterruptedException ex) {
                this.takeGuard_.notify();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void allowTake() {
        Object object = this.takeGuard_;
        synchronized (object) {
            this.takeGuard_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) {
        --this.putSidePutPermits_;
        LinkedNode p = new LinkedNode(x);
        LinkedNode linkedNode = this.last_;
        synchronized (linkedNode) {
            this.last_.next = p;
            this.last_ = p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.closed) {
            throw new IllegalStateException("Channel is closed");
        }
        Object object = this.putGuard_;
        synchronized (object) {
            if (this.putSidePutPermits_ <= 0) {
                BoundedLinkedQueue boundedLinkedQueue = this;
                synchronized (boundedLinkedQueue) {
                    if (this.reconcilePutPermits() <= 0) {
                        try {
                            do {
                                if (this.closed) {
                                    throw new IllegalStateException("Channel is closed");
                                }
                                this.wait();
                            } while (this.reconcilePutPermits() <= 0);
                        }
                        catch (InterruptedException ex) {
                            this.notify();
                            throw ex;
                        }
                    }
                }
            }
            this.insert(x);
        }
        this.allowTake();
    }

    /*
     * Exception decompiling
     */
    public boolean offer(Object x, long msecs) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            return this.head_.next == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List closeAndFlush() {
        Object o;
        this.closed = true;
        Object object = this.putGuard_;
        synchronized (object) {
            BoundedLinkedQueue boundedLinkedQueue = this;
            synchronized (boundedLinkedQueue) {
                this.takeSidePutPermits_ -= this.capacity_;
                this.capacity_ = 0;
                this.reconcilePutPermits();
                this.notifyAll();
            }
        }
        object = this.takeGuard_;
        synchronized (object) {
            this.takeGuard_.notifyAll();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        while ((o = this.extract()) != null) {
            l.add(o);
        }
        return l;
    }

    public static class LinkedNode {
        public Object value;
        public LinkedNode next;

        public LinkedNode() {
        }

        public LinkedNode(Object x) {
            this.value = x;
        }

        public LinkedNode(Object x, LinkedNode n) {
            this.value = x;
            this.next = n;
        }
    }
}

