/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.CopyTransformer;
import org.apache.servicemix.components.util.MessageTransformer;
import org.apache.servicemix.components.util.PojoSupport;
import org.apache.servicemix.jbi.NoInMessageAvailableException;
import org.apache.servicemix.tck.MessageList;
import org.apache.servicemix.tck.Receiver;

public class ReceiverPojo
extends PojoSupport
implements ComponentLifeCycle,
MessageExchangeListener,
Receiver {
    public static final QName SERVICE = new QName("http://servicemix.org/example/", "receiver");
    public static final String ENDPOINT = "receiver";
    private MessageList messageList = new MessageList();
    private MessageTransformer messageTransformer = CopyTransformer.getInstance();

    public ReceiverPojo() {
        this(SERVICE, ENDPOINT);
    }

    public ReceiverPojo(QName service, String endpoint) {
        super(service, endpoint);
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        NormalizedMessage inMessage = this.getInMessage(exchange);
        NormalizedMessage copyMessage = exchange.createMessage();
        this.getMessageTransformer().transform(exchange, inMessage, copyMessage);
        this.messageList.addMessage(copyMessage);
        this.done(exchange);
    }

    protected NormalizedMessage getInMessage(MessageExchange exchange) throws NoInMessageAvailableException {
        NormalizedMessage message = exchange.getMessage("in");
        if (message == null) {
            throw new NoInMessageAvailableException(exchange);
        }
        return message;
    }

    public MessageTransformer getMessageTransformer() {
        return this.messageTransformer;
    }

    public MessageList getMessageList() {
        return this.messageList;
    }
}

