/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.resolver.EndpointResolver;
import org.apache.servicemix.jbi.resolver.NullEndpointFilter;
import org.apache.servicemix.tck.Sender;

public class SenderComponent
extends ComponentSupport
implements Sender {
    public static final QName SERVICE = new QName("http://servicemix.org/example/", "sender");
    public static final String ENDPOINT = "sender";
    private EndpointResolver resolver;
    private String message = "<s12:Envelope xmlns:s12='http://www.w3.org/2003/05/soap-envelope'><s12:Body> <foo>Hello!</foo> </s12:Body></s12:Envelope>";

    public SenderComponent() {
        super(SERVICE, ENDPOINT);
    }

    public EndpointResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(EndpointResolver resolver) {
        this.resolver = resolver;
    }

    public void sendMessages(int messageCount) throws JBIException {
        this.sendMessages(messageCount, false);
    }

    public void sendMessages(int messageCount, boolean sync) throws JBIException {
        ComponentContext context = this.getContext();
        for (int i = 0; i < messageCount; ++i) {
            InOnly exchange = context.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
            NormalizedMessage message = exchange.createMessage();
            ServiceEndpoint destination = null;
            if (this.resolver != null) {
                destination = this.resolver.resolveEndpoint(this.getContext(), (MessageExchange)exchange, NullEndpointFilter.getInstance());
            }
            if (destination != null) {
                exchange.setEndpoint(destination);
            }
            exchange.setInMessage(message);
            message.setContent((Source)new StringSource(this.message));
            if (sync) {
                boolean result = context.getDeliveryChannel().sendSync((MessageExchange)exchange, 1000L);
                if (result) continue;
                throw new MessagingException("Message delivery using sendSync has timed out");
            }
            context.getDeliveryChannel().send((MessageExchange)exchange);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

