/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.PojoSupport;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.tck.ReceiverPojo;
import org.apache.servicemix.tck.Sender;

public class SenderPojo
extends PojoSupport
implements ComponentLifeCycle,
Sender {
    public static final QName SERVICE = new QName("http://servicemix.org/example/", "sender");
    public static final String ENDPOINT = "sender";
    private static final Log log = LogFactory.getLog((Class)SenderPojo.class);
    private QName interfaceName;
    private int numMessages = 10;
    private ComponentContext context;
    private List messages = new ArrayList();
    boolean done = false;

    public SenderPojo() {
        this(ReceiverPojo.SERVICE);
    }

    public SenderPojo(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void init(ComponentContext context) throws JBIException {
        this.context = context;
        context.activateEndpoint(SERVICE, ENDPOINT);
    }

    public int messagesReceived() {
        return this.messages.size();
    }

    public void sendMesssages() throws MessagingException {
        this.sendMessages(this.numMessages);
    }

    public void sendMessages(int messageCount) throws MessagingException {
        this.sendMessages(messageCount, true);
    }

    public void sendMessages(int messageCount, boolean sync) throws MessagingException {
        System.out.println("Looking for services for interface: " + this.interfaceName);
        ServiceEndpoint[] endpoints = this.context.getEndpointsForService(this.interfaceName);
        if (endpoints.length > 0) {
            ServiceEndpoint endpoint = endpoints[0];
            System.out.println("Sending to endpoint: " + endpoint);
            for (int i = 0; i < messageCount; ++i) {
                InOnly exchange = this.context.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
                NormalizedMessage message = exchange.createMessage();
                exchange.setEndpoint(endpoint);
                exchange.setInMessage(message);
                String xml = "<s12:Envelope xmlns:s12='http://www.w3.org/2003/05/soap-envelope'><s12:Body> <foo>Hello!</foo> </s12:Body></s12:Envelope>";
                message.setContent((Source)new StringSource(xml));
                System.out.println("sending message: " + i);
                DeliveryChannel deliveryChannel = this.context.getDeliveryChannel();
                System.out.println("sync send on deliverychannel: " + deliveryChannel);
                if (sync) {
                    deliveryChannel.sendSync((MessageExchange)exchange);
                    continue;
                }
                deliveryChannel.send((MessageExchange)exchange);
            }
        } else {
            log.warn((Object)("No endpoints available for interface: " + this.interfaceName));
        }
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public int getNumMessages() {
        return this.numMessages;
    }

    public void setNumMessages(int numMessages) {
        this.numMessages = numMessages;
    }
}

