/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.context.GeronimoTransactionContext;

class GeronimoTransactionDelegate
implements Transaction {
    private GeronimoTransactionContext context;

    GeronimoTransactionDelegate(GeronimoTransactionContext context) {
        this.context = context;
    }

    public GeronimoTransactionContext getContext() {
        return this.context;
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
        if (this.context.txnManager.transactionContextManager.getContext() != this.context) {
            throw new IllegalStateException("Cannot commit if the transaction is not bound to the current thread");
        }
        this.context.txnManager.commit();
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        return this.context.delistResource(xaResource, flag);
    }

    public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
        return this.context.enlistResource(xaResource);
    }

    public int getStatus() throws SystemException {
        return this.context.getTransaction().getStatus();
    }

    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
        this.context.registerSynchronization(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.context.txnManager.transactionContextManager.getContext() != this.context) {
            throw new IllegalStateException("Cannot commit if the transaction is not bound to the current thread");
        }
        this.context.txnManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.context.setRollbackOnly();
    }
}

