/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.ConnectionMetaData;

public class ActiveMQConnectionMetaData
implements ConnectionMetaData {
    public static final String PROVIDER_VERSION;
    public static final int PROVIDER_MAJOR_VERSION;
    public static final int PROVIDER_MINOR_VERSION;
    public static final ActiveMQConnectionMetaData INSTANCE;

    private ActiveMQConnectionMetaData() {
    }

    public String getJMSVersion() {
        return "1.1";
    }

    public int getJMSMajorVersion() {
        return 1;
    }

    public int getJMSMinorVersion() {
        return 1;
    }

    public String getJMSProviderName() {
        return "ActiveMQ";
    }

    public String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    public int getProviderMajorVersion() {
        return PROVIDER_MAJOR_VERSION;
    }

    public int getProviderMinorVersion() {
        return PROVIDER_MINOR_VERSION;
    }

    public Enumeration getJMSXPropertyNames() {
        Hashtable<String, String> jmxProperties = new Hashtable<String, String>();
        jmxProperties.put("JMSXGroupID", "1");
        jmxProperties.put("JMSXGroupSeq", "1");
        jmxProperties.put("JMSXDeliveryCount", "1");
        return jmxProperties.keys();
    }

    static {
        INSTANCE = new ActiveMQConnectionMetaData();
        String version = null;
        int major = 0;
        int minor = 0;
        try {
            Package p = Package.getPackage("org.apache.activemq");
            if (p != null) {
                version = p.getImplementationVersion();
                Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+).*");
                Matcher m = pattern.matcher(version);
                if (m.matches()) {
                    major = Integer.parseInt(m.group(1));
                    minor = Integer.parseInt(m.group(2));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROVIDER_VERSION = version;
        PROVIDER_MAJOR_VERSION = major;
        PROVIDER_MINOR_VERSION = minor;
    }
}

