/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.MessageDispatchChannel;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQSessionExecutor
implements Task {
    private ActiveMQSession session;
    private MessageDispatchChannel messageQueue = new MessageDispatchChannel();
    private boolean dispatchedBySessionPool;
    private TaskRunner taskRunner;

    ActiveMQSessionExecutor(ActiveMQSession session) {
        this.session = session;
    }

    void setDispatchedBySessionPool(boolean value) {
        this.dispatchedBySessionPool = value;
        this.wakeup();
    }

    void execute(MessageDispatch message) throws InterruptedException {
        if (!this.session.isSessionAsyncDispatch() && !this.dispatchedBySessionPool) {
            this.dispatch(message);
        } else {
            this.messageQueue.enqueue(message);
            this.wakeup();
        }
    }

    private void wakeup() {
        if (this.taskRunner != null && !this.dispatchedBySessionPool && this.hasUncomsumedMessages()) {
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void executeFirst(MessageDispatch message) {
        this.messageQueue.enqueueFirst(message);
        this.wakeup();
    }

    public boolean hasUncomsumedMessages() {
        return !this.messageQueue.isClosed() && this.messageQueue.isRunning() && !this.messageQueue.isEmpty();
    }

    public void run() {
    }

    void dispatch(MessageDispatch message) {
        Iterator i = this.session.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            ConsumerId consumerId = message.getConsumerId();
            if (!consumerId.equals(consumer.getConsumerId())) continue;
            consumer.dispatch(message);
        }
    }

    synchronized void start() {
        if (!this.messageQueue.isRunning()) {
            this.messageQueue.start();
            this.taskRunner = ActiveMQConnection.SESSION_TASK_RUNNER.createTaskRunner(this, "ActiveMQ Session: " + this.session.getSessionId());
            this.wakeup();
        }
    }

    void stop() throws JMSException {
        try {
            if (this.messageQueue.isRunning()) {
                this.messageQueue.stop();
                this.taskRunner.shutdown();
            }
        }
        catch (InterruptedException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    boolean isRunning() {
        return this.messageQueue.isRunning();
    }

    void close() {
        this.messageQueue.close();
    }

    void clear() {
        this.messageQueue.clear();
    }

    MessageDispatch dequeueNoWait() {
        return this.messageQueue.dequeueNoWait();
    }

    protected void clearMessagesInProgress() {
        this.messageQueue.clear();
    }

    public boolean isEmpty() {
        return this.messageQueue.isEmpty();
    }

    public boolean iterate() {
        MessageDispatch message = this.messageQueue.dequeueNoWait();
        if (message == null) {
            return false;
        }
        this.dispatch(message);
        return this.messageQueue.isRunning();
    }

    List getUnconsumedMessages() {
        return this.messageQueue.removeAll();
    }
}

