/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.Service;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.ConnectionStatistics;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.IntegerResponse;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConnection
implements Service,
Connection,
Task,
CommandVisitor {
    private static final Log log = LogFactory.getLog((String)AbstractConnection.class.getName());
    private static final Log transportLog = LogFactory.getLog((String)(AbstractConnection.class.getName() + ".Transport"));
    private static final Log serviceLog = LogFactory.getLog((String)(AbstractConnection.class.getName() + ".Service"));
    protected final Broker broker;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    protected final List dispatchQueue = Collections.synchronizedList(new LinkedList());
    protected final TaskRunner taskRunner;
    protected final TransportConnector connector;
    protected BrokerInfo brokerInfo;
    private ConnectionStatistics statistics = new ConnectionStatistics();
    private boolean inServiceException = false;
    private boolean manageable;
    protected final ConcurrentHashMap connectionStates = new ConcurrentHashMap();
    private WireFormatInfo wireFormatInfo;
    protected boolean disposed = false;

    public AbstractConnection(TransportConnector connector, Broker broker, TaskRunnerFactory taskRunnerFactory) {
        this.connector = connector;
        this.broker = broker;
        if (connector != null) {
            this.statistics.setParent(connector.getStatistics());
        }
        this.taskRunner = taskRunnerFactory != null ? taskRunnerFactory.createTaskRunner(this, "ActiveMQ Connection Dispatcher: " + System.identityHashCode(this)) : null;
    }

    public int getDispatchQueueSize() {
        return this.dispatchQueue.size();
    }

    public void start() throws Exception {
        this.processDispatch(this.connector.getBrokerInfo());
    }

    public void stop() throws Exception {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        if (!this.broker.isStopped()) {
            ArrayList l = new ArrayList(this.connectionStates.keySet());
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                ConnectionId connectionId = (ConnectionId)iter.next();
                try {
                    this.processRemoveConnection(connectionId);
                }
                catch (Throwable ignore) {}
            }
            if (this.brokerInfo != null) {
                this.broker.removeBroker(this, this.brokerInfo);
            }
        }
    }

    public void serviceTransportException(IOException e) {
        if (!this.disposed) {
            if (transportLog.isDebugEnabled()) {
                transportLog.debug((Object)("Transport failed: " + e), (Throwable)e);
            }
            ServiceSupport.dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceException(Throwable e) {
        if (e instanceof IOException) {
            this.serviceTransportException((IOException)e);
        } else if (!this.disposed && !this.inServiceException) {
            this.inServiceException = true;
            try {
                serviceLog.info((Object)("Async error occurred: " + e), e);
                ConnectionError ce = new ConnectionError();
                ce.setException(e);
                this.dispatchAsync(ce);
            }
            finally {
                this.inServiceException = false;
            }
        }
    }

    public Response service(Command command) {
        Response response = null;
        boolean responseRequired = command.isResponseRequired();
        int commandId = command.getCommandId();
        try {
            response = command.visit(this);
        }
        catch (Throwable e) {
            if (responseRequired) {
                serviceLog.info((Object)("Sync error occurred: " + e), e);
                response = new ExceptionResponse(e);
            }
            this.serviceException(e);
        }
        if (responseRequired) {
            if (response == null) {
                response = new Response();
            }
            response.setCorrelationId(commandId);
        }
        return response;
    }

    protected ConnectionState lookupConnectionState(ConsumerId id) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)id.getParentId().getParentId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a consumer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    protected ConnectionState lookupConnectionState(ProducerId id) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)id.getParentId().getParentId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a producer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    protected ConnectionState lookupConnectionState(SessionId id) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)id.getParentId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a session from a connection that had not been registered: " + id.getParentId());
        }
        return cs;
    }

    protected ConnectionState lookupConnectionState(ConnectionId connectionId) {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a connection that had not been registered: " + connectionId);
        }
        return cs;
    }

    public Response processKeepAlive(KeepAliveInfo info) throws Exception {
        return null;
    }

    public Response processRemoveSubscription(RemoveSubscriptionInfo info) throws Exception {
        this.broker.removeSubscription(this.lookupConnectionState(info.getConnectionId()).getContext(), info);
        return null;
    }

    public Response processWireFormat(WireFormatInfo info) throws Exception {
        this.wireFormatInfo = info;
        return null;
    }

    public Response processShutdown(ShutdownInfo info) throws Exception {
        this.stop();
        return null;
    }

    public Response processFlush(FlushCommand command) throws Exception {
        return null;
    }

    public Response processBeginTransaction(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.beginTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processEndTransaction(TransactionInfo info) throws Exception {
        return null;
    }

    public Response processPrepareTransaction(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        int result = this.broker.prepareTransaction(context, info.getTransactionId());
        IntegerResponse response = new IntegerResponse(result);
        return response;
    }

    public Response processCommitTransactionOnePhase(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.commitTransaction(context, info.getTransactionId(), true);
        return null;
    }

    public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.commitTransaction(context, info.getTransactionId(), false);
        return null;
    }

    public Response processRollbackTransaction(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.rollbackTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processForgetTransaction(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        this.broker.forgetTransaction(context, info.getTransactionId());
        return null;
    }

    public Response processRecoverTransactions(TransactionInfo info) throws Exception {
        ConnectionState cs = (ConnectionState)this.connectionStates.get((Object)info.getConnectionId());
        ConnectionContext context = null;
        if (cs != null) {
            context = cs.getContext();
        }
        DataStructure[] preparedTransactions = this.broker.getPreparedTransactions(context);
        return new DataArrayResponse(preparedTransactions);
    }

    public Response processMessage(Message messageSend) throws Exception {
        ProducerId producerId = messageSend.getProducerId();
        ConnectionState state = this.lookupConnectionState(producerId);
        ConnectionContext context = state.getContext();
        this.broker.send(context, messageSend);
        return null;
    }

    public Response processMessageAck(MessageAck ack) throws Exception {
        this.broker.acknowledge(this.lookupConnectionState(ack.getConsumerId()).getContext(), ack);
        return null;
    }

    public Response processMessageDispatchNotification(MessageDispatchNotification notification) throws Exception {
        this.broker.processDispatchNotification(notification);
        return null;
    }

    public Response processBrokerInfo(BrokerInfo info) {
        this.broker.addBroker(this, info);
        return null;
    }

    public Response processAddDestination(DestinationInfo info) throws Exception {
        ConnectionState cs = this.lookupConnectionState(info.getConnectionId());
        this.broker.addDestinationInfo(cs.getContext(), info);
        if (info.getDestination().isTemporary()) {
            cs.addTempDestination(info);
        }
        return null;
    }

    public Response processRemoveDestination(DestinationInfo info) throws Exception {
        ConnectionState cs = this.lookupConnectionState(info.getConnectionId());
        this.broker.removeDestinationInfo(cs.getContext(), info);
        if (info.getDestination().isTemporary()) {
            cs.removeTempDestination(info.getDestination());
        }
        return null;
    }

    public Response processAddProducer(ProducerInfo info) throws Exception {
        SessionId sessionId = info.getProducerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot add a producer to a session that had not been registered: " + sessionId);
        }
        this.broker.addProducer(cs.getContext(), info);
        ss.addProducer(info);
        return null;
    }

    public Response processRemoveProducer(ProducerId id) throws Exception {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a producer from a session that had not been registered: " + sessionId);
        }
        ProducerState ps = ss.removeProducer(id);
        if (ps == null) {
            throw new IllegalStateException("Cannot remove a producer that had not been registered: " + id);
        }
        this.broker.removeProducer(cs.getContext(), ps.getInfo());
        return null;
    }

    public Response processAddConsumer(ConsumerInfo info) throws Exception {
        SessionId sessionId = info.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot add a consumer to a session that had not been registered: " + sessionId);
        }
        this.broker.addConsumer(cs.getContext(), info);
        ss.addConsumer(info);
        return null;
    }

    public Response processRemoveConsumer(ConsumerId id) throws Exception {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + sessionId);
        }
        ConsumerState consumerState = ss.removeConsumer(id);
        if (consumerState == null) {
            throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + id);
        }
        this.broker.removeConsumer(cs.getContext(), consumerState.getInfo());
        return null;
    }

    public Response processAddSession(SessionInfo info) throws Exception {
        ConnectionId connectionId = info.getSessionId().getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        this.broker.addSession(cs.getContext(), info);
        cs.addSession(info);
        return null;
    }

    public Response processRemoveSession(SessionId id) throws Exception {
        ConnectionId connectionId = id.getParentId();
        ConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState session = cs.getSessionState(id);
        if (session == null) {
            throw new IllegalStateException("Cannot remove session that had not been registered: " + id);
        }
        Iterator iter = session.getConsumerIds().iterator();
        while (iter.hasNext()) {
            ConsumerId consumerId = (ConsumerId)iter.next();
            try {
                this.processRemoveConsumer(consumerId);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to remove consumer: " + consumerId + ". Reason: " + e), e);
            }
        }
        iter = session.getProducerIds().iterator();
        while (iter.hasNext()) {
            ProducerId producerId = (ProducerId)iter.next();
            try {
                this.processRemoveProducer(producerId);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to remove producer: " + producerId + ". Reason: " + e), e);
            }
        }
        cs.removeSession(id);
        this.broker.removeSession(cs.getContext(), session.getInfo());
        return null;
    }

    public Response processAddConnection(ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        ConnectionContext context = new ConnectionContext();
        context.setConnection(this);
        context.setBroker(this.broker);
        context.setConnector(this.connector);
        context.setTransactions(new ConcurrentHashMap());
        context.setClientId(clientId);
        context.setUserName(info.getUserName());
        context.setConnectionId(info.getConnectionId());
        context.setWireFormatInfo(this.wireFormatInfo);
        this.manageable = info.isManageable();
        this.connectionStates.put((Object)info.getConnectionId(), (Object)new ConnectionState(info, context));
        this.broker.addConnection(context, info);
        if (info.isManageable() && this.broker.isFaultTolerantConfiguration()) {
            ConnectionControl command = new ConnectionControl();
            command.setFaultTolerant(this.broker.isFaultTolerantConfiguration());
            this.dispatchAsync(command);
        }
        return null;
    }

    public Response processRemoveConnection(ConnectionId id) {
        ConnectionState cs = this.lookupConnectionState(id);
        Iterator iter = cs.getSessionIds().iterator();
        while (iter.hasNext()) {
            SessionId sessionId = (SessionId)iter.next();
            try {
                this.processRemoveSession(sessionId);
            }
            catch (Throwable e) {
                serviceLog.warn((Object)("Failed to remove session " + sessionId), e);
            }
        }
        iter = cs.getTempDesinations().iterator();
        while (iter.hasNext()) {
            DestinationInfo di = (DestinationInfo)iter.next();
            try {
                this.broker.removeDestination(cs.getContext(), di.getDestination(), 0L);
            }
            catch (Throwable e) {
                serviceLog.warn((Object)("Failed to remove tmp destination " + di.getDestination()), e);
            }
            iter.remove();
        }
        try {
            this.broker.removeConnection(cs.getContext(), cs.getInfo(), null);
        }
        catch (Throwable e) {
            serviceLog.warn((Object)("Failed to remove connection " + cs.getInfo()), e);
        }
        this.connectionStates.remove((Object)id);
        return null;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void dispatchSync(Command message) {
        this.processDispatch(message);
    }

    public void dispatchAsync(Command message) {
        if (this.taskRunner == null) {
            this.dispatchSync(message);
        } else {
            this.dispatchQueue.add(message);
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatch(Command command) {
        if (command.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)command;
            Runnable sub = (Runnable)md.getConsumer();
            this.broker.processDispatch(md);
            try {
                this.dispatch(command);
            }
            finally {
                if (sub != null) {
                    sub.run();
                }
            }
        } else {
            this.dispatch(command);
        }
    }

    public boolean iterate() {
        if (this.dispatchQueue.isEmpty() || this.broker.isStopped()) {
            return false;
        }
        Command command = (Command)this.dispatchQueue.remove(0);
        this.processDispatch(command);
        return true;
    }

    public boolean isSlow() {
        return false;
    }

    public boolean isBlocked() {
        return false;
    }

    public boolean isConnected() {
        return !this.disposed;
    }

    public boolean isActive() {
        return !this.disposed;
    }

    protected abstract void dispatch(Command var1);

    public ConnectionStatistics getStatistics() {
        return this.statistics;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    public boolean isManageable() {
        return this.manageable;
    }

    static class ConnectionState
    extends org.apache.activemq.state.ConnectionState {
        private final ConnectionContext context;

        public ConnectionState(ConnectionInfo info, ConnectionContext context) {
            super(info);
            this.context = context;
        }

        public ConnectionContext getContext() {
            return this.context;
        }
    }
}

