/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionMetaData;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.CompositeDestinationBroker;
import org.apache.activemq.broker.ErrorBroker;
import org.apache.activemq.broker.MutableBrokerFilter;
import org.apache.activemq.broker.TransactionBroker;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.UserIDBroker;
import org.apache.activemq.broker.ft.MasterConnector;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.ConnectorView;
import org.apache.activemq.broker.jmx.FTConnectorView;
import org.apache.activemq.broker.jmx.JmsConnectorView;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.NetworkConnectorView;
import org.apache.activemq.broker.jmx.ProxyConnectorView;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.network.ConnectionFilter;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.network.jms.JmsConnector;
import org.apache.activemq.proxy.ProxyConnector;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.store.DefaultPersistenceAdapterFactory;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.vm.VMTransportFactory;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.JMXSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrokerService
implements Service,
Serializable {
    public static final String DEFAULT_PORT = "61616";
    private static final Log log = LogFactory.getLog((Class)BrokerService.class);
    private static final long serialVersionUID = 7353129142305630237L;
    private boolean useJmx = true;
    private boolean persistent = true;
    private boolean populateJMSXUserID = false;
    private boolean useShutdownHook = true;
    private boolean useLoggingForShutdownErrors = false;
    private boolean shutdownOnMasterFailure = false;
    private String brokerName = "localhost";
    private File dataDirectory;
    private Broker broker;
    private BrokerView adminView;
    private ManagementContext managementContext;
    private ObjectName brokerObjectName;
    private TaskRunnerFactory taskRunnerFactory;
    private UsageManager memoryManager;
    private PersistenceAdapter persistenceAdapter;
    private PersistenceAdapterFactory persistenceFactory;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private List transportConnectors = new CopyOnWriteArrayList();
    private List networkConnectors = new CopyOnWriteArrayList();
    private List proxyConnectors = new CopyOnWriteArrayList();
    private List registeredMBeanNames = new CopyOnWriteArrayList();
    private List jmsConnectors = new CopyOnWriteArrayList();
    private MasterConnector masterConnector;
    private transient Thread shutdownHook;
    private String[] transportConnectorURIs;
    private String[] networkConnectorURIs;
    private String[] proxyConnectorURIs;
    private String masterConnectorURI;
    private JmsConnector[] jmsBridgeConnectors;
    private boolean deleteAllMessagesOnStartup;
    private URI vmConnectorURI;
    private PolicyMap destinationPolicy;
    private AtomicBoolean started = new AtomicBoolean(false);
    private BrokerPlugin[] plugins;
    private boolean keepDurableSubsActive = true;
    private BrokerId brokerId;

    public TransportConnector addConnector(String bindAddress) throws Exception {
        return this.addConnector(new URI(bindAddress));
    }

    public TransportConnector addConnector(URI bindAddress) throws Exception {
        return this.addConnector(this.createTransportConnector(this.getBroker(), bindAddress));
    }

    public TransportConnector addConnector(TransportServer transport) throws Exception {
        return this.addConnector(new TransportConnector(this.getBroker(), transport));
    }

    public TransportConnector addConnector(TransportConnector connector) throws Exception {
        this.transportConnectors.add(connector);
        return connector;
    }

    public NetworkConnector addNetworkConnector(String discoveryAddress) throws Exception {
        return this.addNetworkConnector(new URI(discoveryAddress));
    }

    public ProxyConnector addProxyConnector(String bindAddress) throws Exception {
        return this.addProxyConnector(new URI(bindAddress));
    }

    public NetworkConnector addNetworkConnector(URI discoveryAddress) throws Exception {
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(discoveryAddress);
        return this.addNetworkConnector(connector);
    }

    public ProxyConnector addProxyConnector(URI bindAddress) throws Exception {
        ProxyConnector connector = new ProxyConnector();
        connector.setBind(bindAddress);
        connector.setRemote(new URI("fanout:multicast://default"));
        return this.addProxyConnector(connector);
    }

    public NetworkConnector addNetworkConnector(NetworkConnector connector) throws Exception {
        URI uri = this.getVmConnectorURI();
        HashMap<String, String> map = new HashMap<String, String>(URISupport.parseParamters(uri));
        map.put("network", "true");
        uri = URISupport.createURIWithQuery(uri, URISupport.createQueryString(map));
        connector.setLocalUri(uri);
        connector.setConnectionFilter(new ConnectionFilter(){

            public boolean connectTo(URI location) {
                List transportConnectors = BrokerService.this.getTransportConnectors();
                Iterator iter = transportConnectors.iterator();
                while (iter.hasNext()) {
                    try {
                        TransportConnector tc = (TransportConnector)iter.next();
                        if (!location.equals(tc.getConnectUri())) continue;
                        return false;
                    }
                    catch (Throwable e) {
                    }
                }
                return true;
            }
        });
        this.networkConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerNetworkConnectorMBean(connector);
        }
        return connector;
    }

    public ProxyConnector addProxyConnector(ProxyConnector connector) throws Exception {
        URI uri = this.getVmConnectorURI();
        connector.setLocalUri(uri);
        this.proxyConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerProxyConnectorMBean(connector);
        }
        return connector;
    }

    public JmsConnector addJmsConnector(JmsConnector connector) throws Exception {
        connector.setBrokerService(this);
        this.jmsConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerJmsConnectorMBean(connector);
        }
        return connector;
    }

    public JmsConnector removeJmsConnector(JmsConnector connector) {
        if (this.jmsConnectors.remove(connector)) {
            return connector;
        }
        return null;
    }

    public void initializeMasterConnector(URI remoteURI) throws Exception {
        if (this.masterConnector != null) {
            throw new IllegalStateException("Can only be the Slave to one Master");
        }
        URI localURI = this.getVmConnectorURI();
        TransportConnector connector = null;
        if (!this.transportConnectors.isEmpty()) {
            connector = (TransportConnector)this.transportConnectors.get(0);
        }
        this.masterConnector = new MasterConnector(this, connector);
        this.masterConnector.setLocalURI(localURI);
        this.masterConnector.setRemoteURI(remoteURI);
        if (this.isUseJmx()) {
            this.registerFTConnectorMBean(this.masterConnector);
        }
    }

    public String getMasterConnectorURI() {
        return this.masterConnectorURI;
    }

    public void setMasterConnectorURI(String masterConnectorURI) {
        this.masterConnectorURI = masterConnectorURI;
    }

    public boolean isSlave() {
        return this.masterConnector != null && this.masterConnector.isSlave();
    }

    public void masterFailed() {
        if (this.shutdownOnMasterFailure) {
            log.fatal((Object)"The Master has failed ... shutting down");
            try {
                this.stop();
            }
            catch (Exception e) {
                log.error((Object)"Failed to stop for master failure", (Throwable)e);
            }
        } else {
            log.warn((Object)"Master Failed - starting all connectors");
            try {
                this.startAllConnectors();
            }
            catch (Exception e) {
                log.error((Object)"Failed to startAllConnectors");
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processHelperProperties();
            BrokerRegistry.getInstance().bind(this.getBrokerName(), this);
            this.addShutdownHook();
            if (this.deleteAllMessagesOnStartup) {
                this.deleteAllMessages();
            }
            if (this.isUseJmx()) {
                this.getManagementContext().start();
            }
            this.getBroker().start();
            if (this.masterConnectorURI != null) {
                this.initializeMasterConnector(new URI(this.masterConnectorURI));
                if (this.masterConnector != null) {
                    this.masterConnector.start();
                }
            }
            this.startAllConnectors();
            this.brokerId = this.broker.getBrokerId();
            log.info((Object)("ActiveMQ JMS Message Broker (" + this.getBrokerName() + ", " + this.brokerId + ") started"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to start ActiveMQ JMS Message Broker. Reason: " + e), (Throwable)e);
            throw e;
        }
    }

    public void stop() throws Exception {
        Service connector;
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        log.info((Object)("ActiveMQ Message Broker (" + this.getBrokerName() + ", " + this.brokerId + ") is shutting down"));
        BrokerRegistry.getInstance().unbind(this.getBrokerName());
        this.removeShutdownHook();
        ServiceStopper stopper = new ServiceStopper();
        if (this.masterConnector != null) {
            this.masterConnector.stop();
        }
        Iterator iter = this.getNetworkConnectors().iterator();
        while (iter.hasNext()) {
            connector = (NetworkConnector)iter.next();
            stopper.stop(connector);
        }
        iter = this.getProxyConnectors().iterator();
        while (iter.hasNext()) {
            connector = (ProxyConnector)iter.next();
            stopper.stop(connector);
        }
        iter = this.jmsConnectors.iterator();
        while (iter.hasNext()) {
            connector = (JmsConnector)iter.next();
            stopper.stop(connector);
        }
        iter = this.getTransportConnectors().iterator();
        while (iter.hasNext()) {
            connector = (TransportConnector)iter.next();
            stopper.stop(connector);
        }
        VMTransportFactory.stopped(this.getBrokerName());
        stopper.stop(this.persistenceAdapter);
        if (this.broker != null) {
            stopper.stop(this.broker);
        }
        if (this.isUseJmx()) {
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            if (mbeanServer != null) {
                Iterator iter2 = this.registeredMBeanNames.iterator();
                while (iter2.hasNext()) {
                    ObjectName name = (ObjectName)iter2.next();
                    try {
                        mbeanServer.unregisterMBean(name);
                    }
                    catch (Exception e) {
                        stopper.onException(mbeanServer, e);
                    }
                }
            }
            stopper.stop(this.getManagementContext());
        }
        log.info((Object)("ActiveMQ JMS Message Broker (" + this.getBrokerName() + ", " + this.brokerId + ") stopped"));
        stopper.throwFirstException();
    }

    public Broker getBroker() throws Exception {
        if (this.broker == null) {
            log.info((Object)("ActiveMQ " + ActiveMQConnectionMetaData.PROVIDER_VERSION + " JMS Message Broker (" + this.getBrokerName() + ") is starting"));
            log.info((Object)"For help or more information please see: http://incubator.apache.org/activemq/");
            this.broker = this.createBroker();
        }
        return this.broker;
    }

    public BrokerView getAdminView() throws Exception {
        if (this.adminView == null) {
            this.getBroker();
        }
        return this.adminView;
    }

    public void setAdminView(BrokerView adminView) {
        this.adminView = adminView;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public PersistenceAdapterFactory getPersistenceFactory() {
        if (this.persistenceFactory == null) {
            this.persistenceFactory = this.createPersistenceFactory();
        }
        return this.persistenceFactory;
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = new File(new File("activemq-data"), this.getBrokerName().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_"));
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void setPersistenceFactory(PersistenceAdapterFactory persistenceFactory) {
        this.persistenceFactory = persistenceFactory;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPopulateJMSXUserID() {
        return this.populateJMSXUserID;
    }

    public void setPopulateJMSXUserID(boolean populateJMSXUserID) {
        this.populateJMSXUserID = populateJMSXUserID;
    }

    public UsageManager getMemoryManager() {
        if (this.memoryManager == null) {
            this.memoryManager = new UsageManager();
            this.memoryManager.setLimit(0x1400000L);
        }
        return this.memoryManager;
    }

    public void setMemoryManager(UsageManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public PersistenceAdapter getPersistenceAdapter() throws IOException {
        if (this.persistenceAdapter == null) {
            this.persistenceAdapter = this.createPersistenceAdapter();
        }
        return this.persistenceAdapter;
    }

    public void setPersistenceAdapter(PersistenceAdapter persistenceAdapter) {
        this.persistenceAdapter = persistenceAdapter;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory();
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public boolean isUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(boolean useJmx) {
        this.useJmx = useJmx;
    }

    public ObjectName getBrokerObjectName() throws IOException {
        if (this.brokerObjectName == null) {
            this.brokerObjectName = this.createBrokerObjectName();
        }
        return this.brokerObjectName;
    }

    public void setBrokerObjectName(ObjectName brokerObjectName) {
        this.brokerObjectName = brokerObjectName;
    }

    public ManagementContext getManagementContext() {
        if (this.managementContext == null) {
            this.managementContext = new ManagementContext();
        }
        return this.managementContext;
    }

    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public String[] getNetworkConnectorURIs() {
        return this.networkConnectorURIs;
    }

    public void setNetworkConnectorURIs(String[] networkConnectorURIs) {
        this.networkConnectorURIs = networkConnectorURIs;
    }

    public String[] getTransportConnectorURIs() {
        return this.transportConnectorURIs;
    }

    public void setTransportConnectorURIs(String[] transportConnectorURIs) {
        this.transportConnectorURIs = transportConnectorURIs;
    }

    public JmsConnector[] getJmsBridgeConnectors() {
        return this.jmsBridgeConnectors;
    }

    public void setJmsBridgeConnectors(JmsConnector[] jmsConnectors) {
        this.jmsBridgeConnectors = jmsConnectors;
    }

    public boolean isUseLoggingForShutdownErrors() {
        return this.useLoggingForShutdownErrors;
    }

    public void setUseLoggingForShutdownErrors(boolean useLoggingForShutdownErrors) {
        this.useLoggingForShutdownErrors = useLoggingForShutdownErrors;
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public List getTransportConnectors() {
        return new ArrayList(this.transportConnectors);
    }

    public void setTransportConnectors(List transportConnectors) throws Exception {
        Iterator iter = transportConnectors.iterator();
        while (iter.hasNext()) {
            TransportConnector connector = (TransportConnector)iter.next();
            this.addConnector(connector);
        }
    }

    public List getNetworkConnectors() {
        return new ArrayList(this.networkConnectors);
    }

    public List getProxyConnectors() {
        return new ArrayList(this.proxyConnectors);
    }

    public void setNetworkConnectors(List networkConnectors) throws Exception {
        Iterator iter = networkConnectors.iterator();
        while (iter.hasNext()) {
            NetworkConnector connector = (NetworkConnector)iter.next();
            this.addNetworkConnector(connector);
        }
    }

    public void setProxyConnectors(List proxyConnectors) throws Exception {
        Iterator iter = proxyConnectors.iterator();
        while (iter.hasNext()) {
            ProxyConnector connector = (ProxyConnector)iter.next();
            this.addProxyConnector(connector);
        }
    }

    public PolicyMap getDestinationPolicy() {
        return this.destinationPolicy;
    }

    public void setDestinationPolicy(PolicyMap policyMap) {
        this.destinationPolicy = policyMap;
    }

    public BrokerPlugin[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(BrokerPlugin[] plugins) {
        this.plugins = plugins;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    public void deleteAllMessages() throws IOException {
        this.getPersistenceAdapter().deleteAllMessages();
    }

    protected void processHelperProperties() throws Exception {
        String uri;
        int i;
        if (this.transportConnectorURIs != null) {
            for (i = 0; i < this.transportConnectorURIs.length; ++i) {
                uri = this.transportConnectorURIs[i];
                this.addConnector(uri);
            }
        }
        if (this.networkConnectorURIs != null) {
            for (i = 0; i < this.networkConnectorURIs.length; ++i) {
                uri = this.networkConnectorURIs[i];
                this.addNetworkConnector(uri);
            }
        }
        if (this.proxyConnectorURIs != null) {
            for (i = 0; i < this.proxyConnectorURIs.length; ++i) {
                uri = this.proxyConnectorURIs[i];
                this.addProxyConnector(uri);
            }
        }
        if (this.jmsBridgeConnectors != null) {
            for (i = 0; i < this.jmsBridgeConnectors.length; ++i) {
                this.addJmsConnector(this.jmsBridgeConnectors[i]);
            }
        }
    }

    protected void registerConnectorMBean(TransportConnector connector, ObjectName objectName) throws IOException, URISyntaxException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        if (mbeanServer != null) {
            ConnectorView view = new ConnectorView(connector);
            try {
                mbeanServer.registerMBean(view, objectName);
                this.registeredMBeanNames.add(objectName);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
            }
        }
    }

    protected void registerNetworkConnectorMBean(NetworkConnector connector) throws IOException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        if (mbeanServer != null) {
            NetworkConnectorView view = new NetworkConnectorView(connector);
            try {
                ObjectName objectName = new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=NetworkConnector," + "NetworkConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
                mbeanServer.registerMBean(view, objectName);
                this.registeredMBeanNames.add(objectName);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
            }
        }
    }

    protected void registerProxyConnectorMBean(ProxyConnector connector) throws IOException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        if (mbeanServer != null) {
            ProxyConnectorView view = new ProxyConnectorView(connector);
            try {
                ObjectName objectName = new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=ProxyConnector," + "ProxyConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
                mbeanServer.registerMBean(view, objectName);
                this.registeredMBeanNames.add(objectName);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
            }
        }
    }

    protected void registerFTConnectorMBean(MasterConnector connector) throws IOException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        if (mbeanServer != null) {
            FTConnectorView view = new FTConnectorView(connector);
            try {
                ObjectName objectName = new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=MasterConnector");
                mbeanServer.registerMBean(view, objectName);
                this.registeredMBeanNames.add(objectName);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
            }
        }
    }

    protected void registerJmsConnectorMBean(JmsConnector connector) throws IOException {
        MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
        if (mbeanServer != null) {
            JmsConnectorView view = new JmsConnectorView(connector);
            try {
                ObjectName objectName = new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=JmsConnector," + "JmsConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
                mbeanServer.registerMBean(view, objectName);
                this.registeredMBeanNames.add(objectName);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
            }
        }
    }

    protected Broker createBroker() throws Exception {
        Broker regionBroker = this.createRegionBroker();
        Broker broker = this.addInterceptors(regionBroker);
        broker = new MutableBrokerFilter(broker){

            public void stop() throws Exception {
                super.stop();
                this.setNext(new ErrorBroker("Broker has been stopped: " + this){

                    public void stop() throws Exception {
                    }
                });
            }
        };
        if (this.isUseJmx()) {
            ManagedRegionBroker managedBroker = (ManagedRegionBroker)regionBroker;
            managedBroker.setContextBroker(broker);
            this.adminView = new BrokerView(this, managedBroker);
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            if (mbeanServer != null) {
                ObjectName objectName = this.getBrokerObjectName();
                mbeanServer.registerMBean(this.adminView, objectName);
                this.registeredMBeanNames.add(objectName);
            }
        }
        return broker;
    }

    protected Broker createRegionBroker() throws Exception {
        this.getPersistenceAdapter().setUsageManager(this.getMemoryManager());
        this.getPersistenceAdapter().start();
        RegionBroker regionBroker = null;
        if (this.isUseJmx()) {
            MBeanServer mbeanServer = this.getManagementContext().getMBeanServer();
            regionBroker = new ManagedRegionBroker(this, mbeanServer, this.getBrokerObjectName(), this.getTaskRunnerFactory(), this.getMemoryManager(), this.getPersistenceAdapter());
        } else {
            regionBroker = new RegionBroker(this, this.getTaskRunnerFactory(), this.getMemoryManager(), this.getPersistenceAdapter());
        }
        regionBroker.setKeepDurableSubsActive(this.keepDurableSubsActive);
        regionBroker.setBrokerName(this.getBrokerName());
        return regionBroker;
    }

    protected Broker addInterceptors(Broker broker) throws Exception {
        broker = new TransactionBroker(broker, this.getPersistenceAdapter().createTransactionStore());
        broker = new AdvisoryBroker(broker);
        broker = new CompositeDestinationBroker(broker);
        if (this.isPopulateJMSXUserID()) {
            broker = new UserIDBroker(broker);
        }
        if (this.plugins != null) {
            for (int i = 0; i < this.plugins.length; ++i) {
                BrokerPlugin plugin = this.plugins[i];
                broker = plugin.installPlugin(broker);
            }
        }
        return broker;
    }

    protected PersistenceAdapter createPersistenceAdapter() throws IOException {
        if (this.isPersistent()) {
            return this.getPersistenceFactory().createPersistenceAdapter();
        }
        return new MemoryPersistenceAdapter();
    }

    protected DefaultPersistenceAdapterFactory createPersistenceFactory() {
        DefaultPersistenceAdapterFactory factory = new DefaultPersistenceAdapterFactory();
        factory.setDataDirectory(this.getDataDirectory());
        factory.setTaskRunnerFactory(this.getTaskRunnerFactory());
        return factory;
    }

    protected ObjectName createBrokerObjectName() throws IOException {
        try {
            return new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=Broker");
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Invalid JMX broker name: " + this.brokerName, e);
        }
    }

    protected TransportConnector createTransportConnector(Broker broker, URI brokerURI) throws Exception {
        TransportServer transport = TransportFactory.bind(this.getBrokerName(), brokerURI);
        return new TransportConnector(broker, transport);
    }

    protected Object getPort(Map options) {
        Object port = options.get("port");
        if (port == null) {
            port = DEFAULT_PORT;
            log.warn((Object)("No port specified so defaulting to: " + port));
        }
        return port;
    }

    protected void addShutdownHook() {
        if (this.useShutdownHook) {
            this.shutdownHook = new Thread("ActiveMQ ShutdownHook"){

                public void run() {
                    BrokerService.this.containerShutdown();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception e) {
                log.debug((Object)("Caught exception, must be shutting down: " + e));
            }
        }
    }

    protected void containerShutdown() {
        try {
            this.stop();
        }
        catch (IOException e) {
            Throwable linkedException = e.getCause();
            if (linkedException != null) {
                this.logError("Failed to shut down: " + e + ". Reason: " + linkedException, linkedException);
            } else {
                this.logError("Failed to shut down: " + e, e);
            }
            if (!this.useLoggingForShutdownErrors) {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            this.logError("Failed to shut down: " + e, e);
        }
    }

    protected void logError(String message, Throwable e) {
        if (this.useLoggingForShutdownErrors) {
            log.error((Object)("Failed to shut down: " + e));
        } else {
            System.err.println("Failed to shut down: " + e);
        }
    }

    protected void startAllConnectors() throws Exception {
        if (!this.isSlave()) {
            Service connector;
            Iterator iter = this.getTransportConnectors().iterator();
            while (iter.hasNext()) {
                connector = (TransportConnector)iter.next();
                this.startTransportConnector((TransportConnector)connector);
            }
            iter = this.getNetworkConnectors().iterator();
            while (iter.hasNext()) {
                connector = (NetworkConnector)iter.next();
                ((NetworkConnector)connector).setBrokerName(this.getBrokerName());
                ((NetworkConnector)connector).setDurableDestinations(this.getBroker().getDurableDestinations());
                ((ServiceSupport)connector).start();
            }
            iter = this.getProxyConnectors().iterator();
            while (iter.hasNext()) {
                connector = (ProxyConnector)iter.next();
                ((ProxyConnector)connector).start();
            }
            iter = this.jmsConnectors.iterator();
            while (iter.hasNext()) {
                connector = (JmsConnector)iter.next();
                ((JmsConnector)connector).start();
            }
        }
    }

    protected void startTransportConnector(TransportConnector connector) throws Exception {
        connector.setBroker(this.getBroker());
        connector.setBrokerName(this.getBrokerName());
        connector.setTaskRunnerFactory(this.getTaskRunnerFactory());
        MessageAuthorizationPolicy policy = this.getMessageAuthorizationPolicy();
        if (policy != null) {
            connector.setMessageAuthorizationPolicy(policy);
        }
        if (this.isUseJmx()) {
            ObjectName objectName = new ObjectName(this.managementContext.getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=Connector," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
            connector = connector.asManagedConnector(this.getManagementContext().getMBeanServer(), objectName);
            this.registerConnectorMBean(connector, objectName);
        }
        connector.start();
    }

    public boolean isDeleteAllMessagesOnStartup() {
        return this.deleteAllMessagesOnStartup;
    }

    public void setDeleteAllMessagesOnStartup(boolean deletePersistentMessagesOnStartup) {
        this.deleteAllMessagesOnStartup = deletePersistentMessagesOnStartup;
    }

    public URI getVmConnectorURI() {
        if (this.vmConnectorURI == null) {
            try {
                this.vmConnectorURI = new URI("vm://" + this.getBrokerName());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.vmConnectorURI;
    }

    public void setVmConnectorURI(URI vmConnectorURI) {
        this.vmConnectorURI = vmConnectorURI;
    }

    public boolean isShutdownOnMasterFailure() {
        return this.shutdownOnMasterFailure;
    }

    public void setShutdownOnMasterFailure(boolean shutdownOnMasterFailure) {
        this.shutdownOnMasterFailure = shutdownOnMasterFailure;
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }
}

