/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.IOException;
import org.apache.activemq.broker.AbstractConnection;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.MutableBrokerFilter;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.ft.MasterBroker;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportConnection
extends AbstractConnection {
    private static final Log log = LogFactory.getLog((Class)TransportConnection.class);
    private final Transport transport;
    private boolean slow;
    private boolean markedCandidate;
    private boolean blockedCandidate;
    private boolean blocked;
    private boolean connected;
    private boolean active;
    private long timeStamp = 0L;
    private MasterBroker masterBroker;

    public TransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory taskRunnerFactory) {
        super(connector, broker, taskRunnerFactory);
        connector.setBrokerName(broker.getBrokerName());
        this.transport = transport;
        this.transport.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Command command) {
                Response response = TransportConnection.this.service(command);
                if (response != null) {
                    TransportConnection.this.dispatch(response);
                }
            }

            public void onException(IOException exception) {
                TransportConnection.this.serviceTransportException(exception);
            }
        });
        this.connected = true;
    }

    public void start() throws Exception {
        this.transport.start();
        this.active = true;
        super.start();
        this.connector.onStarted(this);
    }

    public void stop() throws Exception {
        this.connector.onStopped(this);
        try {
            if (this.masterBroker != null) {
                this.masterBroker.stop();
            }
            this.transport.oneway(new ShutdownInfo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transport.stop();
        this.active = false;
        super.stop();
    }

    public boolean isBlockedCandidate() {
        return this.blockedCandidate;
    }

    public void setBlockedCandidate(boolean blockedCandidate) {
        this.blockedCandidate = blockedCandidate;
    }

    public boolean isMarkedCandidate() {
        return this.markedCandidate;
    }

    public void setMarkedCandidate(boolean markedCandidate) {
        this.markedCandidate = markedCandidate;
        if (!markedCandidate) {
            this.timeStamp = 0L;
            this.blockedCandidate = false;
        }
    }

    public void setSlow(boolean slow) {
        this.slow = slow;
    }

    public boolean isSlow() {
        return this.slow;
    }

    public boolean isMarkedBlockedCandidate() {
        return this.markedCandidate;
    }

    public void doMark() {
        if (this.timeStamp == 0L) {
            this.timeStamp = System.currentTimeMillis();
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Response processBrokerInfo(BrokerInfo info) {
        if (info.isSlaveBroker()) {
            MutableBrokerFilter parent = (MutableBrokerFilter)this.broker.getAdaptor(MutableBrokerFilter.class);
            this.masterBroker = new MasterBroker(parent, this.transport);
            this.masterBroker.startProcessing();
            log.info((Object)("Slave Broker " + info.getBrokerName() + " is attached"));
        }
        return super.processBrokerInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(Command command) {
        try {
            this.setMarkedCandidate(true);
            this.transport.oneway(command);
            this.getStatistics().onCommand(command);
        }
        catch (IOException e) {
            this.serviceException(e);
        }
        finally {
            this.setMarkedCandidate(false);
        }
    }
}

