/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.IOException;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ConnectionView;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.JMXSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedTransportConnection
extends TransportConnection {
    private static final Log log = LogFactory.getLog((Class)ManagedTransportConnection.class);
    private final MBeanServer server;
    private final ObjectName connectorName;
    private ConnectionViewMBean mbean;
    private ObjectName name;
    private String connectionId;

    public ManagedTransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory factory, MBeanServer server, ObjectName connectorName, String connectionId) throws IOException {
        super(connector, transport, broker, factory);
        this.server = server;
        this.connectorName = connectorName;
        this.mbean = new ConnectionView(this);
        this.setConnectionId(connectionId);
    }

    public void stop() throws Exception {
        this.unregisterMBean();
        super.stop();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) throws IOException {
        this.connectionId = connectionId;
        this.unregisterMBean();
        this.name = this.createObjectName();
        this.registerMBean();
    }

    public Response processAddConnection(ConnectionInfo info) throws Exception {
        Response answer = super.processAddConnection(info);
        String clientId = info.getClientId();
        if (clientId != null) {
            this.setConnectionId(clientId);
        }
        return answer;
    }

    protected void registerMBean() throws IOException {
        try {
            this.server.registerMBean(this.mbean, this.name);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected void unregisterMBean() {
        if (this.name != null) {
            try {
                this.server.unregisterMBean(this.name);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to unregister mbean: " + this.name));
            }
        }
    }

    protected ObjectName createObjectName() throws IOException {
        Hashtable<String, String> map = this.connectorName.getKeyPropertyList();
        try {
            return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(map.get("BrokerName")) + "," + "Type=Connection," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(map.get("ConnectorName")) + "," + "Connection=" + JMXSupport.encodeObjectNamePart(this.connectionId));
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

