/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.DestinationView;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;

public class QueueView
extends DestinationView
implements QueueViewMBean {
    public QueueView(ManagedRegionBroker broker, Queue destination) {
        super(broker, destination);
    }

    public CompositeData getMessage(String messageId) throws OpenDataException {
        Message rc = ((Queue)this.destination).getMessage(messageId);
        if (rc == null) {
            return null;
        }
        return OpenTypeSupport.convert(rc);
    }

    public boolean removeMessage(String messageId) {
        return ((Queue)this.destination).removeMessage(messageId);
    }

    public void purge() {
        ((Queue)this.destination).purge();
    }

    public boolean copyMessageTo(String messageId, String destinationName) throws Exception {
        return ((Queue)this.destination).copyMessageTo(BrokerView.getConnectionContext(this.broker.getContextBroker()), messageId, ActiveMQDestination.createDestination(destinationName, (byte)1));
    }
}

