/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;

public class SubscriptionView
implements SubscriptionViewMBean {
    protected final Subscription subscription;
    protected final String clientId;

    public SubscriptionView(String clientId, Subscription subs) {
        this.clientId = clientId;
        this.subscription = subs;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getConnectionId() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            return info.getConsumerId().getConnectionId();
        }
        return "NOTSET";
    }

    public long getSessionId() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            return info.getConsumerId().getSessionId();
        }
        return 0L;
    }

    public long getSubcriptionId() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            return info.getConsumerId().getValue();
        }
        return 0L;
    }

    public String getDestinationName() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            ActiveMQDestination dest = info.getDestination();
            return dest.getPhysicalName();
        }
        return "NOTSET";
    }

    public String getSelector() {
        if (this.subscription != null) {
            return this.subscription.getSelector();
        }
        return null;
    }

    public void setSelector(String selector) throws InvalidSelectorException, UnsupportedOperationException {
        if (this.subscription == null) {
            throw new UnsupportedOperationException("No subscription object");
        }
        this.subscription.setSelector(selector);
    }

    public boolean isDestinationQueue() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            ActiveMQDestination dest = info.getDestination();
            return dest.isQueue();
        }
        return false;
    }

    public boolean isDestinationTopic() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            ActiveMQDestination dest = info.getDestination();
            return dest.isTopic();
        }
        return false;
    }

    public boolean isDestinationTemporary() {
        ConsumerInfo info = this.getConsumerInfo();
        if (info != null) {
            ActiveMQDestination dest = info.getDestination();
            return dest.isTemporary();
        }
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public void gc() {
        if (this.subscription != null) {
            this.subscription.gc();
        }
    }

    public int getPendingQueueSize() {
        return this.subscription != null ? this.subscription.getPendingQueueSize() : 0;
    }

    public int getDispatchedQueueSize() {
        return this.subscription != null ? this.subscription.getDispatchedQueueSize() : 0;
    }

    public long getDispachedCounter() {
        return this.subscription != null ? this.subscription.getDispatchedCounter() : 0L;
    }

    public long getEnqueueCounter() {
        return this.subscription != null ? this.subscription.getEnqueueCounter() : 0L;
    }

    public long getDequeueCounter() {
        return this.subscription != null ? this.subscription.getDequeueCounter() : 0L;
    }

    protected ConsumerInfo getConsumerInfo() {
        return this.subscription != null ? this.subscription.getConsumerInfo() : null;
    }

    public String toString() {
        return "SubscriptionView: " + this.getClientId() + ":" + this.getConnectionId();
    }

    public int getPrefetchSize() {
        return this.subscription != null ? this.subscription.getPrefetchSize() : 0;
    }
}

