/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import javax.jms.JMSException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractRegion;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.thread.TaskRunnerFactory;

public class TempTopicRegion
extends AbstractRegion {
    public TempTopicRegion(RegionBroker broker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, null);
        this.setAutoCreateDestinations(false);
    }

    protected Destination createDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        final ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destination;
        return new Topic(destination, null, this.memoryManager, this.destinationStatistics, this.taskRunnerFactory){

            public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
                if (!tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId())) {
                    throw new JMSException("Cannot subscribe to remote temporary destination: " + tempDest);
                }
                super.addSubscription(context, sub);
            }
        };
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        if (info.isDurable()) {
            throw new JMSException("A durable subscription cannot be created for a temporary topic.");
        }
        return new TopicSubscription(this.broker, context, info, this.memoryManager);
    }

    public String toString() {
        return "TempTopicRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }
}

