/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.Iterator;
import java.util.List;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.memory.list.DestinationBasedMessageList;
import org.apache.activemq.memory.list.MessageList;
import org.apache.activemq.memory.list.SimpleMessageList;

public class FixedSizedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private MessageList buffer;
    private int maximumSize = 0x640000;
    private boolean useSharedBuffer = true;

    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        this.buffer.add(message);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConnectionContext context, Topic topic, Subscription sub) throws Exception {
        List copy = this.buffer.getMessages(sub);
        if (!copy.isEmpty()) {
            MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    MessageReference node = (MessageReference)iter.next();
                    msgContext.setDestination(node.getRegionDestination().getActiveMQDestination());
                    msgContext.setMessageReference(node);
                    if (!sub.matches(node, msgContext)) continue;
                    sub.add(node);
                }
            }
            finally {
                msgContext.clear();
            }
        }
    }

    public void start() throws Exception {
        this.buffer = this.createMessageList();
    }

    public void stop() throws Exception {
        this.buffer.clear();
    }

    public MessageList getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MessageList buffer) {
        this.buffer = buffer;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public boolean isUseSharedBuffer() {
        return this.useSharedBuffer;
    }

    public void setUseSharedBuffer(boolean useSharedBuffer) {
        this.useSharedBuffer = useSharedBuffer;
    }

    public Message[] browse(ActiveMQDestination destination) throws Exception {
        return this.buffer.browse(destination);
    }

    protected MessageList createMessageList() {
        if (this.useSharedBuffer) {
            return new SimpleMessageList(this.maximumSize);
        }
        return new DestinationBasedMessageList(this.maximumSize);
    }
}

