/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.filter.DestinationMapNode;

public class DestinationMap {
    protected static final String ANY_DESCENDENT = ">";
    protected static final String ANY_CHILD = "*";
    private DestinationMapNode queueRootNode = new DestinationMapNode(null);
    private DestinationMapNode topicRootNode = new DestinationMapNode(null);

    public synchronized Set get(ActiveMQDestination key) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            HashSet<Set> answer = new HashSet<Set>(destinations.length);
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                Set value = this.get(childDestination);
                if (value instanceof Set) {
                    answer.addAll(value);
                    continue;
                }
                if (value == null) continue;
                answer.add(value);
            }
            return answer;
        }
        return this.findWildcardMatches(key);
    }

    public synchronized void put(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                this.put(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).add(paths, 0, value);
    }

    public synchronized void remove(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                this.remove(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).remove(paths, 0, value);
    }

    public int getTopicRootChildCount() {
        return this.topicRootNode.getChildCount();
    }

    public int getQueueRootChildCount() {
        return this.queueRootNode.getChildCount();
    }

    public DestinationMapNode getQueueRootNode() {
        return this.queueRootNode;
    }

    public DestinationMapNode getTopicRootNode() {
        return this.topicRootNode;
    }

    protected void setEntries(List entries) {
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            Class type = this.getEntryClass();
            if (type.isInstance(element)) {
                DestinationMapEntry entry = (DestinationMapEntry)element;
                this.put(entry.getDestination(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Each entry must be an instance of type: " + type.getName() + " but was: " + element);
        }
    }

    protected Class getEntryClass() {
        return DestinationMapEntry.class;
    }

    protected Set findWildcardMatches(ActiveMQDestination key) {
        String[] paths = key.getDestinationPaths();
        HashSet answer = new HashSet();
        this.getRootNode(key).appendMatchingValues(answer, paths, 0);
        return answer;
    }

    public void removeAll(ActiveMQDestination key) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                this.removeAll(destinations[i]);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).removeAll(paths, 0);
    }

    public Object chooseValue(ActiveMQDestination destination) {
        Set set = this.get(destination);
        if (set == null || set.isEmpty()) {
            return null;
        }
        TreeSet sortedSet = new TreeSet(set);
        return sortedSet.last();
    }

    protected DestinationMapNode getRootNode(ActiveMQDestination key) {
        if (key.isQueue()) {
            return this.queueRootNode;
        }
        return this.topicRootNode;
    }
}

