/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.impl.ContainerId;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.IndexItem;
import org.apache.activemq.kaha.impl.IndexLinkedList;
import org.apache.activemq.kaha.impl.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseContainerImpl {
    private static final Log log = LogFactory.getLog((Class)BaseContainerImpl.class);
    protected IndexItem root;
    protected IndexLinkedList list;
    protected IndexManager indexManager;
    protected DataManager dataManager;
    protected ContainerId containerId;
    protected boolean loaded = false;
    protected boolean closed = false;
    protected final Object mutex = new Object();

    protected BaseContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager) {
        this.containerId = id;
        this.root = root;
        this.indexManager = indexManager;
        this.dataManager = dataManager;
        this.list = new IndexLinkedList(root);
    }

    ContainerId getContainerId() {
        return this.containerId;
    }

    public abstract void unload();

    public abstract void load();

    public abstract int size();

    public abstract void clear();

    protected abstract Object getValue(IndexItem var1);

    protected abstract void remove(IndexItem var1);

    protected final IndexLinkedList getInternalList() {
        return this.list;
    }

    public final void close() {
        this.unload();
        this.closed = true;
    }

    public final boolean isLoaded() {
        this.checkClosed();
        return this.loaded;
    }

    public final Object getId() {
        this.checkClosed();
        return this.containerId.getKey();
    }

    protected final void expressDataInterest() throws IOException {
        long nextItem = this.root.getNextItem();
        while (nextItem != -1L) {
            IndexItem item = this.indexManager.getIndex(nextItem);
            item.setOffset(nextItem);
            this.dataManager.addInterestInFile(item.getKeyFile());
            this.dataManager.addInterestInFile(item.getValueFile());
            nextItem = item.getNextItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doClear() {
        this.checkClosed();
        Object object = this.mutex;
        synchronized (object) {
            this.loaded = true;
            Object object2 = this.mutex;
            synchronized (object2) {
                ArrayList<IndexItem> list = new ArrayList<IndexItem>();
                try {
                    long nextItem = this.root.getNextItem();
                    while (nextItem != -1L) {
                        IndexItem item = new IndexItem();
                        item.setOffset(nextItem);
                        list.add(item);
                        nextItem = item.getNextItem();
                    }
                    this.root.setNextItem(-1L);
                    this.indexManager.updateIndex(this.root);
                    for (int i = 0; i < list.size(); ++i) {
                        IndexItem item = (IndexItem)list.get(i);
                        this.dataManager.removeInterestInFile(item.getKeyFile());
                        this.dataManager.removeInterestInFile(item.getValueFile());
                        this.indexManager.freeIndex(item);
                    }
                    list.clear();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to clear Container " + this.getId()), (Throwable)e);
                    throw new RuntimeStoreException(e);
                }
            }
        }
    }

    protected final void delete(IndexItem key, IndexItem prev, IndexItem next) {
        try {
            this.dataManager.removeInterestInFile(key.getKeyFile());
            this.dataManager.removeInterestInFile(key.getValueFile());
            prev = prev == null ? this.root : prev;
            IndexItem indexItem = next = next != this.root ? next : null;
            if (next != null) {
                prev.setNextItem(next.getOffset());
                next.setPreviousItem(prev.getOffset());
                this.indexManager.updateIndex(next);
            } else {
                prev.setNextItem(-1L);
            }
            this.indexManager.updateIndex(prev);
            this.indexManager.freeIndex(key);
        }
        catch (IOException e) {
            log.error((Object)("Failed to delete " + key), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
    }

    protected final void checkClosed() {
        if (this.closed) {
            throw new RuntimeStoreException("The store is closed");
        }
    }
}

