/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class DataFile {
    private File file;
    private Integer number;
    private int referenceCount;
    private RandomAccessFile randomAcessFile;
    long length = 0L;

    DataFile(File file, int number) {
        this.file = file;
        this.number = new Integer(number);
        this.length = file.exists() ? file.length() : 0L;
    }

    Integer getNumber() {
        return this.number;
    }

    synchronized RandomAccessFile getRandomAccessFile() throws FileNotFoundException {
        if (this.randomAcessFile == null) {
            this.randomAcessFile = new RandomAccessFile(this.file, "rw");
        }
        return this.randomAcessFile;
    }

    synchronized long getLength() {
        return this.length;
    }

    synchronized void incrementLength(int size) {
        this.length += (long)size;
    }

    synchronized void purge() throws IOException {
        if (this.randomAcessFile != null) {
            this.randomAcessFile.close();
            this.randomAcessFile = null;
        }
    }

    synchronized boolean delete() throws IOException {
        this.purge();
        return this.file.delete();
    }

    synchronized void force() throws IOException {
        if (this.randomAcessFile != null) {
            this.randomAcessFile.getFD().sync();
        }
    }

    synchronized void close() throws IOException {
        if (this.randomAcessFile != null) {
            this.randomAcessFile.close();
        }
    }

    synchronized int increment() {
        return ++this.referenceCount;
    }

    synchronized int decrement() {
        return --this.referenceCount;
    }

    synchronized boolean isUnused() {
        return this.referenceCount <= 0;
    }

    public String toString() {
        String result = this.file.getName() + " number = " + this.number + " , length = " + this.length + " refCount = " + this.referenceCount;
        return result;
    }
}

