/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.DataFile;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.StoreDataReader;
import org.apache.activemq.kaha.impl.StoreDataWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class DataManager {
    private static final Log log = LogFactory.getLog((Class)DataManager.class);
    protected static long MAX_FILE_LENGTH = 0x2000000L;
    private final File dir;
    private final String prefix;
    private StoreDataReader reader;
    private StoreDataWriter writer;
    private DataFile currentWriteFile;
    Map fileMap = new HashMap();

    DataManager(File dir, String pf) {
        this.dir = dir;
        this.prefix = pf;
        this.reader = new StoreDataReader(this);
        this.writer = new StoreDataWriter(this);
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return dir.equals(dir) && name.startsWith(DataManager.this.prefix);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName();
                String numStr = name.substring(this.prefix.length(), name.length());
                int num = Integer.parseInt(numStr);
                DataFile dataFile = new DataFile(file, num);
                this.fileMap.put(dataFile.getNumber(), dataFile);
                if (this.currentWriteFile != null && this.currentWriteFile.getNumber() >= num) continue;
                this.currentWriteFile = dataFile;
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    DataFile findSpaceForData(DataItem item) throws IOException {
        if (this.currentWriteFile == null || this.currentWriteFile.getLength() + (long)item.getSize() > MAX_FILE_LENGTH) {
            int nextNum;
            int n = nextNum = this.currentWriteFile != null ? this.currentWriteFile.getNumber() + 1 : 1;
            if (this.currentWriteFile != null && this.currentWriteFile.isUnused()) {
                this.removeDataFile(this.currentWriteFile);
            }
            this.currentWriteFile = this.createAndAddDataFile(nextNum);
        }
        item.setOffset(this.currentWriteFile.getLength());
        item.setFile(this.currentWriteFile.getNumber());
        return this.currentWriteFile;
    }

    RandomAccessFile getDataFile(DataItem item) throws IOException {
        Integer key = new Integer(item.getFile());
        DataFile dataFile = (DataFile)this.fileMap.get(key);
        if (dataFile != null) {
            return dataFile.getRandomAccessFile();
        }
        throw new IOException("Could not locate data file " + this.prefix + item.getFile());
    }

    synchronized Object readItem(Marshaller marshaller, DataItem item) throws IOException {
        return this.reader.readItem(marshaller, item);
    }

    synchronized DataItem storeItem(Marshaller marshaller, Object payload) throws IOException {
        return this.writer.storeItem(marshaller, payload);
    }

    synchronized void close() throws IOException {
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            DataFile dataFile = (DataFile)i.next();
            dataFile.force();
            dataFile.close();
        }
        this.fileMap.clear();
    }

    synchronized void force() throws IOException {
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            DataFile dataFile = (DataFile)i.next();
            dataFile.force();
        }
    }

    synchronized boolean delete() throws IOException {
        boolean result = true;
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            DataFile dataFile = (DataFile)i.next();
            result &= dataFile.delete();
        }
        this.fileMap.clear();
        return result;
    }

    synchronized void addInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = new Integer(file);
            DataFile dataFile = (DataFile)this.fileMap.get(key);
            if (dataFile == null) {
                dataFile = this.createAndAddDataFile(file);
            }
            this.addInterestInFile(dataFile);
        }
    }

    void addInterestInFile(DataFile dataFile) {
        if (dataFile != null) {
            dataFile.increment();
        }
    }

    synchronized void removeInterestInFile(int file) throws IOException {
        if (file >= 0) {
            Integer key = new Integer(file);
            DataFile dataFile = (DataFile)this.fileMap.get(key);
            this.removeInterestInFile(dataFile);
        }
    }

    synchronized void removeInterestInFile(DataFile dataFile) throws IOException {
        if (dataFile != null && dataFile.decrement() <= 0 && dataFile != this.currentWriteFile) {
            this.removeDataFile(dataFile);
        }
    }

    synchronized void consolidateDataFiles() throws IOException {
        DataFile dataFile;
        ArrayList<DataFile> purgeList = new ArrayList<DataFile>();
        Iterator i = this.fileMap.values().iterator();
        while (i.hasNext()) {
            dataFile = (DataFile)i.next();
            if (!dataFile.isUnused() || dataFile == this.currentWriteFile) continue;
            purgeList.add(dataFile);
        }
        for (int i2 = 0; i2 < purgeList.size(); ++i2) {
            dataFile = (DataFile)purgeList.get(i2);
            this.fileMap.remove(dataFile.getNumber());
            boolean result = dataFile.delete();
            log.debug((Object)("discarding data file " + dataFile + (result ? "successful " : "failed")));
        }
    }

    private DataFile createAndAddDataFile(int num) {
        String fileName = this.prefix + num;
        File file = new File(this.dir, fileName);
        DataFile result = new DataFile(file, num);
        this.fileMap.put(result.getNumber(), result);
        return result;
    }

    private void removeDataFile(DataFile dataFile) throws IOException {
        this.fileMap.remove(dataFile.getNumber());
        boolean result = dataFile.delete();
        log.debug((Object)("discarding data file " + dataFile + (result ? "successful " : "failed")));
    }
}

