/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.kaha.impl.BadMagicException;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.Item;

final class IndexItem
implements Item {
    static final int INDEX_SIZE = 43;
    IndexItem next;
    IndexItem prev;
    private long offset = -1L;
    private long previousItem = -1L;
    private long nextItem = -1L;
    private long keyOffset = -1L;
    private int keyFile = -1;
    private long valueOffset = -1L;
    private int valueFile = -1;
    private boolean active = true;

    IndexItem() {
    }

    void reset() {
        this.previousItem = -1L;
        this.nextItem = -1L;
        this.keyOffset = -1L;
        this.keyFile = -1;
        this.valueOffset = -1L;
        this.valueFile = -1;
        this.active = true;
    }

    DataItem getKeyDataItem() {
        DataItem result = new DataItem();
        result.setOffset(this.keyOffset);
        result.setFile(this.keyFile);
        return result;
    }

    DataItem getValueDataItem() {
        DataItem result = new DataItem();
        result.setOffset(this.valueOffset);
        result.setFile(this.valueFile);
        return result;
    }

    void setValueData(DataItem item) {
        this.valueOffset = item.getOffset();
        this.valueFile = item.getFile();
    }

    void setKeyData(DataItem item) {
        this.keyOffset = item.getOffset();
        this.keyFile = item.getFile();
    }

    void write(DataOutput dataOut) throws IOException {
        dataOut.writeShort(31317);
        dataOut.writeBoolean(this.active);
        dataOut.writeLong(this.previousItem);
        dataOut.writeLong(this.nextItem);
        dataOut.writeInt(this.keyFile);
        dataOut.writeLong(this.keyOffset);
        dataOut.writeInt(this.valueFile);
        dataOut.writeLong(this.valueOffset);
    }

    void read(DataInput dataIn) throws IOException {
        if (dataIn.readShort() != 31317) {
            throw new BadMagicException();
        }
        this.active = dataIn.readBoolean();
        this.previousItem = dataIn.readLong();
        this.nextItem = dataIn.readLong();
        this.keyFile = dataIn.readInt();
        this.keyOffset = dataIn.readLong();
        this.valueFile = dataIn.readInt();
        this.valueOffset = dataIn.readLong();
    }

    void setPreviousItem(long newPrevEntry) {
        this.previousItem = newPrevEntry;
    }

    long getPreviousItem() {
        return this.previousItem;
    }

    void setNextItem(long newNextEntry) {
        this.nextItem = newNextEntry;
    }

    long getNextItem() {
        return this.nextItem;
    }

    void setKeyOffset(long newObjectOffset) {
        this.keyOffset = newObjectOffset;
    }

    long getKeyOffset() {
        return this.keyOffset;
    }

    int getKeyFile() {
        return this.keyFile;
    }

    void setKeyFile(int keyFile) {
        this.keyFile = keyFile;
    }

    int getValueFile() {
        return this.valueFile;
    }

    void setValueFile(int valueFile) {
        this.valueFile = valueFile;
    }

    long getValueOffset() {
        return this.valueOffset;
    }

    void setValueOffset(long valueOffset) {
        this.valueOffset = valueOffset;
    }

    boolean isActive() {
        return this.active;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    long getOffset() {
        return this.offset;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    public String toString() {
        String result = "offset=" + this.offset + " , keyFile = " + this.keyFile + " , keyOffset = " + this.keyOffset + ", valueOffset = " + this.valueOffset + " , previousItem = " + this.previousItem + " , nextItem = " + this.nextItem;
        return result;
    }
}

