/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.ObjectMarshaller;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.IndexItem;
import org.apache.activemq.kaha.impl.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class IndexRootContainer {
    private static final Log log = LogFactory.getLog((Class)IndexRootContainer.class);
    protected static final Marshaller rootMarshaller = new ObjectMarshaller();
    protected IndexItem root;
    protected IndexManager indexManager;
    protected DataManager dataManager;
    protected Map map = new ConcurrentHashMap();
    protected LinkedList list = new LinkedList();

    IndexRootContainer(IndexItem root, IndexManager im, DataManager dfm) throws IOException {
        this.root = root;
        this.indexManager = im;
        this.dataManager = dfm;
        long nextItem = root.getNextItem();
        while (nextItem != -1L) {
            IndexItem item = this.indexManager.getIndex(nextItem);
            DataItem data = item.getKeyDataItem();
            Object key = this.dataManager.readItem(rootMarshaller, data);
            this.map.put(key, item);
            this.list.add(item);
            nextItem = item.getNextItem();
            this.dataManager.addInterestInFile(item.getKeyFile());
        }
    }

    Set getKeys() {
        return this.map.keySet();
    }

    IndexItem addRoot(Object key) throws IOException {
        if (this.map.containsKey(key)) {
            this.removeRoot(key);
        }
        DataItem data = this.dataManager.storeItem(rootMarshaller, key);
        IndexItem index = this.indexManager.createNewIndex();
        index.setKeyData(data);
        IndexItem newRoot = this.indexManager.createNewIndex();
        this.indexManager.updateIndex(newRoot);
        index.setValueOffset(newRoot.getOffset());
        IndexItem last = this.list.isEmpty() ? null : (IndexItem)this.list.getLast();
        last = last == null ? this.root : last;
        long prev = last.getOffset();
        index.setPreviousItem(prev);
        this.indexManager.updateIndex(index);
        last.setNextItem(index.getOffset());
        this.indexManager.updateIndex(last);
        this.map.put(key, index);
        this.list.add(index);
        return newRoot;
    }

    void removeRoot(Object key) throws IOException {
        IndexItem item = (IndexItem)this.map.remove(key);
        if (item != null) {
            IndexItem next;
            this.dataManager.removeInterestInFile(item.getKeyFile());
            IndexItem rootIndex = this.indexManager.getIndex(item.getValueOffset());
            this.indexManager.freeIndex(rootIndex);
            int index = this.list.indexOf(item);
            IndexItem prev = index > 0 ? (IndexItem)this.list.get(index - 1) : this.root;
            prev = prev == null ? this.root : prev;
            IndexItem indexItem = next = index < this.list.size() - 1 ? (IndexItem)this.list.get(index + 1) : null;
            if (next != null) {
                prev.setNextItem(next.getOffset());
                next.setPreviousItem(prev.getOffset());
                this.indexManager.updateIndex(next);
            } else {
                prev.setNextItem(-1L);
            }
            this.indexManager.updateIndex(prev);
            this.list.remove(item);
        }
    }

    IndexItem getRoot(Object key) throws IOException {
        IndexItem index = (IndexItem)this.map.get(key);
        if (index != null) {
            return this.indexManager.getIndex(index.getValueOffset());
        }
        throw new IOException("Cannot find root for key " + key);
    }
}

