/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.impl.BaseContainerImpl;
import org.apache.activemq.kaha.impl.ContainerId;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.IndexItem;
import org.apache.activemq.kaha.impl.IndexManager;
import org.apache.activemq.kaha.impl.IndexRootContainer;
import org.apache.activemq.kaha.impl.ListContainerImpl;
import org.apache.activemq.kaha.impl.MapContainerImpl;

public class KahaStore
implements Store {
    private static final String DEFAULT_CONTAINER_NAME = "data-container";
    private File directory;
    private DataManager rootData;
    private DataManager defaultContainerManager;
    private IndexManager indexManager;
    private IndexRootContainer mapsContainer;
    private IndexRootContainer listsContainer;
    private Map lists = new ConcurrentHashMap();
    private Map maps = new ConcurrentHashMap();
    private Map dataManagers = new ConcurrentHashMap();
    private boolean closed = false;
    private String name;
    private String mode;
    private boolean initialized;

    public KahaStore(String name, String mode) throws IOException {
        this.name = name;
        this.mode = mode;
        this.initialize();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.initialized) {
                this.indexManager.close();
                this.rootData.close();
                this.defaultContainerManager.close();
            }
        }
    }

    public synchronized void force() throws IOException {
        if (this.initialized) {
            this.indexManager.force();
            this.rootData.force();
            this.defaultContainerManager.force();
        }
    }

    public synchronized void clear() throws IOException {
        BaseContainerImpl container;
        this.initialize();
        Iterator i = this.maps.values().iterator();
        while (i.hasNext()) {
            container = (BaseContainerImpl)i.next();
            container.clear();
        }
        i = this.lists.values().iterator();
        while (i.hasNext()) {
            container = (BaseContainerImpl)i.next();
            container.clear();
        }
        this.lists.clear();
        this.maps.clear();
    }

    public synchronized boolean delete() throws IOException {
        this.initialize();
        this.clear();
        boolean result = this.indexManager.delete();
        result &= this.rootData.delete();
        this.initialized = false;
        return result &= this.defaultContainerManager.delete();
    }

    public boolean doesMapContainerExist(Object id) throws IOException {
        this.initialize();
        return this.maps.containsKey(id);
    }

    public MapContainer getMapContainer(Object id) throws IOException {
        return this.getMapContainer(id, DEFAULT_CONTAINER_NAME);
    }

    public synchronized MapContainer getMapContainer(Object id, String dataContainerName) throws IOException {
        this.initialize();
        MapContainer result = (MapContainer)this.maps.get(id);
        if (result == null) {
            DataManager dm = this.getDataManager(dataContainerName);
            ContainerId containerId = new ContainerId();
            containerId.setKey(id);
            containerId.setDataContainerPrefix(dataContainerName);
            IndexItem root = this.mapsContainer.addRoot(containerId);
            result = new MapContainerImpl(containerId, root, this.indexManager, dm);
            this.maps.put(containerId.getKey(), result);
        }
        return result;
    }

    public void deleteMapContainer(Object id) throws IOException {
        this.initialize();
        MapContainerImpl container = (MapContainerImpl)this.maps.remove(id);
        if (container != null) {
            container.clear();
            this.mapsContainer.removeRoot(container.getContainerId());
        }
    }

    public Set getMapContainerIds() throws IOException {
        this.initialize();
        return this.maps.keySet();
    }

    public boolean doesListContainerExist(Object id) throws IOException {
        this.initialize();
        return this.lists.containsKey(id);
    }

    public ListContainer getListContainer(Object id) throws IOException {
        return this.getListContainer(id, DEFAULT_CONTAINER_NAME);
    }

    public synchronized ListContainer getListContainer(Object id, String dataContainerName) throws IOException {
        this.initialize();
        ListContainer result = (ListContainer)this.lists.get(id);
        if (result == null) {
            DataManager dm = this.getDataManager(dataContainerName);
            ContainerId containerId = new ContainerId();
            containerId.setKey(id);
            containerId.setDataContainerPrefix(dataContainerName);
            IndexItem root = this.listsContainer.addRoot(containerId);
            result = new ListContainerImpl(containerId, root, this.indexManager, dm);
            this.lists.put(containerId.getKey(), result);
        }
        return result;
    }

    public void deleteListContainer(Object id) throws IOException {
        this.initialize();
        ListContainerImpl container = (ListContainerImpl)this.lists.remove(id);
        if (container != null) {
            container.clear();
            this.listsContainer.removeRoot(container.getContainerId());
        }
    }

    public Set getListContainerIds() throws IOException {
        this.initialize();
        return this.lists.keySet();
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new RuntimeStoreException("The store is closed");
        }
    }

    protected synchronized void initialize() throws IOException {
        if (this.closed) {
            throw new IOException("Store has been closed.");
        }
        if (!this.initialized) {
            BaseContainerImpl container;
            IndexItem root;
            DataManager dm;
            ContainerId key;
            this.initialized = true;
            this.directory = new File(this.name);
            this.directory.mkdirs();
            File ifile = new File(this.directory, "kaha.idx");
            this.indexManager = new IndexManager(ifile, this.mode);
            this.rootData = new DataManager(this.directory, "roots-data");
            this.defaultContainerManager = new DataManager(this.directory, DEFAULT_CONTAINER_NAME);
            this.dataManagers.put(DEFAULT_CONTAINER_NAME, this.defaultContainerManager);
            IndexItem mapRoot = new IndexItem();
            IndexItem listRoot = new IndexItem();
            if (this.indexManager.isEmpty()) {
                mapRoot.setOffset(0L);
                this.indexManager.updateIndex(mapRoot);
                listRoot.setOffset(43L);
                this.indexManager.updateIndex(listRoot);
                this.indexManager.setLength(86L);
            } else {
                mapRoot = this.indexManager.getIndex(0L);
                listRoot = this.indexManager.getIndex(43L);
            }
            this.mapsContainer = new IndexRootContainer(mapRoot, this.indexManager, this.rootData);
            this.listsContainer = new IndexRootContainer(listRoot, this.indexManager, this.rootData);
            this.rootData.consolidateDataFiles();
            Iterator<Object> i = this.mapsContainer.getKeys().iterator();
            while (i.hasNext()) {
                key = (ContainerId)i.next();
                dm = this.getDataManager(key.getDataContainerPrefix());
                root = this.mapsContainer.getRoot(key);
                container = new MapContainerImpl(key, root, this.indexManager, dm);
                container.expressDataInterest();
                this.maps.put(key.getKey(), container);
            }
            i = this.listsContainer.getKeys().iterator();
            while (i.hasNext()) {
                key = (ContainerId)i.next();
                dm = this.getDataManager(key.getDataContainerPrefix());
                root = this.listsContainer.getRoot(key);
                container = new ListContainerImpl(key, root, this.indexManager, dm);
                container.expressDataInterest();
                this.lists.put(key.getKey(), container);
            }
            i = this.dataManagers.values().iterator();
            while (i.hasNext()) {
                DataManager dm2 = (DataManager)i.next();
                dm2.consolidateDataFiles();
            }
        }
    }

    protected DataManager getDataManager(String prefix) {
        DataManager dm = (DataManager)this.dataManagers.get(prefix);
        if (dm == null) {
            dm = new DataManager(this.directory, prefix);
            this.dataManagers.put(prefix, dm);
        }
        return dm;
    }
}

