/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.ObjectMarshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.impl.BaseContainerImpl;
import org.apache.activemq.kaha.impl.ContainerEntrySet;
import org.apache.activemq.kaha.impl.ContainerId;
import org.apache.activemq.kaha.impl.ContainerKeySet;
import org.apache.activemq.kaha.impl.ContainerValueCollection;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.IndexItem;
import org.apache.activemq.kaha.impl.IndexLinkedList;
import org.apache.activemq.kaha.impl.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class MapContainerImpl
extends BaseContainerImpl
implements MapContainer {
    private static final Log log = LogFactory.getLog((Class)MapContainerImpl.class);
    protected Map map = new HashMap();
    protected Map valueToKeyMap = new HashMap();
    protected Marshaller keyMarshaller = new ObjectMarshaller();
    protected Marshaller valueMarshaller = new ObjectMarshaller();

    protected MapContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager) {
        super(id, root, indexManager, dataManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.checkClosed();
        if (!this.loaded) {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.loaded) {
                    this.loaded = true;
                    try {
                        long nextItem = this.root.getNextItem();
                        while (nextItem != -1L) {
                            IndexItem item = this.indexManager.getIndex(nextItem);
                            DataItem data = item.getKeyDataItem();
                            Object key = this.dataManager.readItem(this.keyMarshaller, data);
                            this.map.put(key, item);
                            this.valueToKeyMap.put(item, key);
                            this.list.add(item);
                            nextItem = item.getNextItem();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("Failed to load container " + this.getId()), (Throwable)e);
                        throw new RuntimeStoreException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        this.checkClosed();
        if (this.loaded) {
            this.loaded = false;
            Object object = this.mutex;
            synchronized (object) {
                this.map.clear();
                this.valueToKeyMap.clear();
                this.list.clear();
            }
        }
    }

    public void setKeyMarshaller(Marshaller keyMarshaller) {
        this.checkClosed();
        this.keyMarshaller = keyMarshaller;
    }

    public void setValueMarshaller(Marshaller valueMarshaller) {
        this.checkClosed();
        this.valueMarshaller = valueMarshaller;
    }

    public int size() {
        this.load();
        return this.map.size();
    }

    public boolean isEmpty() {
        this.load();
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.load();
        Object object = this.mutex;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        this.load();
        Object result = null;
        IndexItem item = null;
        Object object = this.mutex;
        synchronized (object) {
            item = (IndexItem)this.map.get(key);
        }
        if (item != null) {
            result = this.getValue(item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexLinkedList indexLinkedList = this.list;
            synchronized (indexLinkedList) {
                IndexItem item = this.list.getFirst();
                while (item != null) {
                    Object value = this.getValue(item);
                    if (value != null && value.equals(o)) {
                        result = true;
                        break;
                    }
                    item = this.list.getNextEntry(item);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map t) {
        this.load();
        if (t != null) {
            Object object = this.mutex;
            synchronized (object) {
                Iterator i = t.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public Set keySet() {
        this.load();
        return new ContainerKeySet(this);
    }

    public Collection values() {
        this.load();
        return new ContainerValueCollection(this);
    }

    public Set entrySet() {
        this.load();
        return new ContainerEntrySet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        this.load();
        Object result = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.map.containsKey(key)) {
                result = this.remove(key);
            }
            IndexItem item = this.write(key, value);
            this.map.put(key, item);
            this.valueToKeyMap.put(item, key);
            this.list.add(item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        this.load();
        Object result = null;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = (IndexItem)this.map.get(key);
            if (item != null) {
                this.map.remove(key);
                this.valueToKeyMap.remove(item);
                result = this.getValue(item);
                IndexItem prev = this.list.getPrevEntry(item);
                prev = prev != null ? prev : this.root;
                IndexItem next = this.list.getNextEntry(item);
                this.list.remove(item);
                this.delete(item, prev, next);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValue(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            Object object = this.mutex;
            synchronized (object) {
                IndexItem item = this.list.getFirst();
                while (item != null) {
                    Object value = this.getValue(item);
                    if (value != null && value.equals(o)) {
                        result = true;
                        Object key = this.valueToKeyMap.get(item);
                        if (key == null) break;
                        this.remove(key);
                        break;
                    }
                    item = this.list.getNextEntry(item);
                }
            }
        }
        return result;
    }

    protected void remove(IndexItem item) {
        Object key = this.valueToKeyMap.get(item);
        if (key != null) {
            this.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.checkClosed();
        Object object = this.mutex;
        synchronized (object) {
            this.loaded = true;
            Object object2 = this.mutex;
            synchronized (object2) {
                this.map.clear();
                this.valueToKeyMap.clear();
                this.list.clear();
                this.doClear();
            }
        }
    }

    protected Set getInternalKeySet() {
        return new HashSet(this.map.keySet());
    }

    protected IndexLinkedList getItemList() {
        return this.list;
    }

    protected Object getValue(IndexItem item) {
        Object result = null;
        if (item != null) {
            try {
                DataItem data = item.getValueDataItem();
                result = this.dataManager.readItem(this.valueMarshaller, data);
            }
            catch (IOException e) {
                log.error((Object)("Failed to get value for " + item), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    protected IndexItem write(Object key, Object value) {
        IndexItem index = null;
        try {
            DataItem data;
            if (key != null) {
                index = this.indexManager.createNewIndex();
                data = this.dataManager.storeItem(this.keyMarshaller, key);
                index.setKeyData(data);
            }
            if (value != null) {
                data = this.dataManager.storeItem(this.valueMarshaller, value);
                index.setValueData(data);
            }
            IndexItem last = this.list.isEmpty() ? null : this.list.getLast();
            last = last == null ? this.root : last;
            long prev = last.getOffset();
            index.setPreviousItem(prev);
            this.indexManager.updateIndex(index);
            last.setNextItem(index.getOffset());
            this.indexManager.updateIndex(last);
        }
        catch (IOException e) {
            log.error((Object)("Failed to write " + key + " , " + value), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }
}

