/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.memory.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.memory.list.MessageList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleMessageList
implements MessageList {
    private static final Log log = LogFactory.getLog((Class)SimpleMessageList.class);
    private LinkedList list = new LinkedList();
    private int maximumSize = 0x640000;
    private int size;
    private Object lock = new Object();

    public SimpleMessageList() {
    }

    public SimpleMessageList(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MessageReference node) {
        int delta = node.getMessageHardRef().getSize();
        Object object = this.lock;
        synchronized (object) {
            this.list.add(node);
            this.size += delta;
            while (this.size > this.maximumSize) {
                MessageReference evicted = (MessageReference)this.list.removeFirst();
                this.size -= evicted.getMessageHardRef().getSize();
            }
        }
    }

    public List getMessages(Subscription sub) {
        return this.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] browse(ActiveMQDestination destination) {
        ArrayList<Message> result = new ArrayList<Message>();
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        Object object = this.lock;
        synchronized (object) {
            Iterator i = this.list.iterator();
            while (i.hasNext()) {
                MessageReference ref = (MessageReference)i.next();
                try {
                    Message msg = ref.getMessage();
                    if (!filter.matches(msg.getDestination())) continue;
                    result.add(msg);
                }
                catch (IOException e) {
                    log.error((Object)("Failed to get Message from MessageReference: " + ref), (Throwable)e);
                }
            }
        }
        return result.toArray(new Message[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getList() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.list.clear();
            this.size = 0;
        }
    }
}

