/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.NetworkBridgeFilter;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.Bridge;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DemandForwardingBridgeSupport
implements Bridge {
    protected static final Log log = LogFactory.getLog((Class)DemandForwardingBridge.class);
    protected final Transport localBroker;
    protected final Transport remoteBroker;
    protected IdGenerator idGenerator = new IdGenerator();
    protected LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    protected ConnectionInfo localConnectionInfo;
    protected ConnectionInfo remoteConnectionInfo;
    protected SessionInfo localSessionInfo;
    protected ProducerInfo producerInfo;
    protected String localBrokerName;
    protected String remoteBrokerName;
    protected String localClientId;
    protected String userName;
    protected String password;
    protected int prefetchSize = 1000;
    protected boolean dispatchAsync;
    protected String destinationFilter = ">";
    protected String name = "bridge";
    protected ConsumerInfo demandConsumerInfo;
    protected int demandConsumerDispatched;
    protected AtomicBoolean localBridgeStarted = new AtomicBoolean(false);
    protected AtomicBoolean remoteBridgeStarted = new AtomicBoolean(false);
    protected boolean disposed = false;
    protected BrokerId localBrokerId;
    protected ActiveMQDestination[] excludedDestinations;
    protected ActiveMQDestination[] dynamicallyIncludedDestinations;
    protected ActiveMQDestination[] staticallyIncludedDestinations;
    protected ActiveMQDestination[] durableDestinations;
    protected ConcurrentHashMap subscriptionMapByLocalId = new ConcurrentHashMap();
    protected ConcurrentHashMap subscriptionMapByRemoteId = new ConcurrentHashMap();
    protected final BrokerId[] localBrokerPath = new BrokerId[]{null};
    protected CountDownLatch startedLatch = new CountDownLatch(2);
    protected boolean decreaseNetworkConsumerPriority;
    protected boolean shutDown;
    protected int networkTTL = 1;

    public DemandForwardingBridgeSupport(Transport localBroker, Transport remoteBroker) {
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void start() throws Exception {
        log.info((Object)("Starting a network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established."));
        this.localBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Command command) {
                DemandForwardingBridgeSupport.this.serviceLocalCommand(command);
            }

            public void onException(IOException error) {
                DemandForwardingBridgeSupport.this.serviceLocalException(error);
            }
        });
        this.remoteBroker.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                DemandForwardingBridgeSupport.this.serviceRemoteCommand(command);
            }

            public void onException(IOException error) {
                DemandForwardingBridgeSupport.this.serviceRemoteException(error);
            }

            public synchronized void transportInterupted() {
                log.warn((Object)("Outbound transport to " + DemandForwardingBridgeSupport.this.remoteBrokerName + " interrupted ..."));
                DemandForwardingBridgeSupport.this.clearDownSubscriptions();
                DemandForwardingBridgeSupport.this.doStopLocal();
                DemandForwardingBridgeSupport.this.startedLatch = new CountDownLatch(2);
                try {
                    DemandForwardingBridgeSupport.this.triggerLocalStartBridge();
                }
                catch (IOException e) {
                    log.warn((Object)"Caught exception from local start", (Throwable)e);
                }
            }

            public synchronized void transportResumed() {
                log.info((Object)("Outbound transport to " + DemandForwardingBridgeSupport.this.remoteBrokerName + " resumed"));
                DemandForwardingBridgeSupport.this.setupStaticDestinations();
                DemandForwardingBridgeSupport.this.startedLatch.countDown();
            }
        });
        this.localBroker.start();
        this.remoteBroker.start();
        this.triggerRemoteStartBridge();
    }

    protected void triggerLocalStartBridge() throws IOException {
        Thread thead = new Thread(){

            public void run() {
                try {
                    DemandForwardingBridgeSupport.this.startLocalBridge();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to start network bridge: " + e), (Throwable)e);
                }
            }
        };
        thead.start();
    }

    protected void triggerRemoteStartBridge() throws IOException {
        Thread thead = new Thread(){

            public void run() {
                try {
                    DemandForwardingBridgeSupport.this.startRemoteBridge();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to start network bridge: " + e), (Throwable)e);
                }
            }
        };
        thead.start();
    }

    protected void startLocalBridge() throws IOException {
        if (this.localBridgeStarted.compareAndSet(false, true)) {
            this.localConnectionInfo = new ConnectionInfo();
            this.localConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
            this.localClientId = "NC_" + this.remoteBrokerName + "_inbound" + this.name;
            this.localConnectionInfo.setClientId(this.localClientId);
            this.localConnectionInfo.setUserName(this.userName);
            this.localConnectionInfo.setPassword(this.password);
            this.localBroker.oneway(this.localConnectionInfo);
            this.localSessionInfo = new SessionInfo(this.localConnectionInfo, 1L);
            this.localBroker.oneway(this.localSessionInfo);
            log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + "(" + this.remoteBrokerName + ") has been established."));
            this.startedLatch.countDown();
            this.setupStaticDestinations();
        }
    }

    protected void startRemoteBridge() throws IOException {
        if (this.remoteBridgeStarted.compareAndSet(false, true)) {
            this.remoteConnectionInfo = new ConnectionInfo();
            this.remoteConnectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
            this.remoteConnectionInfo.setClientId("NC_" + this.localBrokerName + "_outbound" + this.name);
            this.remoteConnectionInfo.setUserName(this.userName);
            this.remoteConnectionInfo.setPassword(this.password);
            this.remoteBroker.oneway(this.remoteConnectionInfo);
            BrokerInfo brokerInfo = new BrokerInfo();
            brokerInfo.setBrokerName(this.localBrokerName);
            this.remoteBroker.oneway(brokerInfo);
            SessionInfo remoteSessionInfo = new SessionInfo(this.remoteConnectionInfo, 1L);
            this.remoteBroker.oneway(remoteSessionInfo);
            this.producerInfo = new ProducerInfo(remoteSessionInfo, 1L);
            this.producerInfo.setResponseRequired(false);
            this.remoteBroker.oneway(this.producerInfo);
            this.demandConsumerInfo = new ConsumerInfo(remoteSessionInfo, 1L);
            this.demandConsumerInfo.setDispatchAsync(this.dispatchAsync);
            this.demandConsumerInfo.setDestination(new ActiveMQTopic("ActiveMQ.Advisory.Consumer." + this.destinationFilter));
            this.demandConsumerInfo.setPrefetchSize(this.prefetchSize);
            this.remoteBroker.oneway(this.demandConsumerInfo);
            ConsumerInfo destinationInfo = new ConsumerInfo(remoteSessionInfo, 2L);
            destinationInfo.setDestination(AdvisorySupport.TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC);
            destinationInfo.setPrefetchSize(this.prefetchSize);
            this.remoteBroker.oneway(destinationInfo);
            this.startedLatch.countDown();
        }
    }

    public void stop() throws Exception {
        this.shutDown = true;
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        log.debug((Object)(" stopping " + this.localBrokerName + " bridge to " + this.remoteBrokerName + " is disposed already ? " + this.disposed));
        if (!this.disposed) {
            try {
                this.disposed = true;
                this.remoteBridgeStarted.set(false);
                if (!this.shutDown) {
                    this.remoteBroker.oneway(new ShutdownInfo());
                    if (this.localConnectionInfo != null) {
                        this.localBroker.oneway(this.localConnectionInfo.createRemoveCommand());
                        this.remoteBroker.oneway(this.remoteConnectionInfo.createRemoveCommand());
                    }
                    this.localBroker.oneway(new ShutdownInfo());
                }
                this.localBroker.setTransportListener(null);
                this.remoteBroker.setTransportListener(null);
            }
            catch (IOException e) {
                log.debug((Object)"Caught exception stopping", (Throwable)e);
            }
            finally {
                ServiceStopper ss = new ServiceStopper();
                ss.stop(this.localBroker);
                ss.stop(this.remoteBroker);
                ss.throwFirstException();
            }
        }
        log.debug((Object)(this.localBrokerName + " bridge to " + this.remoteBrokerName + " stopped"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStopLocal() {
        try {
            if (!this.shutDown) {
                if (this.localConnectionInfo != null) {
                    this.localBroker.oneway(this.localConnectionInfo.createRemoveCommand());
                }
                this.localBroker.oneway(new ShutdownInfo());
            }
            this.localBroker.setTransportListener(null);
        }
        catch (IOException e) {
            log.debug((Object)"Caught exception stopping", (Throwable)e);
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
        }
    }

    protected void serviceRemoteException(Exception error) {
        log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage()), (Throwable)error);
        ServiceSupport.dispose(this);
    }

    protected void serviceRemoteCommand(Command command) {
        if (!this.disposed) {
            try {
                if (command.isMessageDispatch()) {
                    this.waitStarted();
                    MessageDispatch md = (MessageDispatch)command;
                    this.serviceRemoteConsumerAdvisory(md.getMessage().getDataStructure());
                    ++this.demandConsumerDispatched;
                    if ((double)this.demandConsumerDispatched > (double)this.demandConsumerInfo.getPrefetchSize() * 0.75) {
                        this.remoteBroker.oneway(new MessageAck(md, 2, this.demandConsumerDispatched));
                        this.demandConsumerDispatched = 0;
                    }
                } else if (command.isBrokerInfo()) {
                    this.serviceRemoteBrokerInfo(command);
                } else {
                    switch (command.getDataStructureType()) {
                        case 1: 
                        case 10: {
                            break;
                        }
                        default: {
                            log.warn((Object)("Unexpected remote command: " + command));
                        }
                    }
                }
            }
            catch (Exception e) {
                this.serviceRemoteException(e);
            }
        }
    }

    private void serviceRemoteConsumerAdvisory(DataStructure data) throws IOException {
        if (data.getClass() == ConsumerInfo.class) {
            ConsumerInfo info = (ConsumerInfo)data;
            BrokerId[] path = info.getBrokerPath();
            if (path != null && path.length >= this.networkTTL) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ignoring Subscription " + info + " restricted to " + this.networkTTL + " network hops only"));
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(info.getBrokerPath(), this.localBrokerPath[0])) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ignoring sub " + info + " already routed through this broker once"));
                }
                return;
            }
            if (!this.isPermissableDestination(info.getDestination())) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ignoring sub " + info + " destination " + info.getDestination() + " is not permiited"));
                }
                return;
            }
            info = info.copy();
            this.addRemoteBrokerToBrokerPath(info);
            DemandSubscription sub = this.createDemandSubscription(info);
            if (sub != null) {
                this.addSubscription(sub);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Forwarding sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + info));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Ignoring sub " + info + " already subscribed to matching destination"));
            }
        } else if (data.getClass() == DestinationInfo.class) {
            DestinationInfo destInfo = (DestinationInfo)data;
            BrokerId[] path = destInfo.getBrokerPath();
            if (path != null && path.length >= this.networkTTL) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ignoring Subscription " + destInfo + " restricted to " + this.networkTTL + " network hops only"));
                }
                return;
            }
            if (DemandForwardingBridgeSupport.contains(destInfo.getBrokerPath(), this.localBrokerPath[0])) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ignoring sub " + destInfo + " already routed through this broker once"));
                }
                return;
            }
            destInfo.setConnectionId(this.localConnectionInfo.getConnectionId());
            if (destInfo.getDestination() instanceof ActiveMQTempDestination) {
                ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destInfo.getDestination();
                tempDest.setConnectionId(this.localSessionInfo.getSessionId().getConnectionId());
            }
            destInfo.setBrokerPath(this.appendToBrokerPath(destInfo.getBrokerPath(), this.getRemoteBrokerPath()));
            this.localBroker.oneway(destInfo);
        } else if (data.getClass() == RemoveInfo.class) {
            ConsumerId id = (ConsumerId)((RemoveInfo)data).getObjectId();
            this.removeDemandSubscription(id);
        }
    }

    protected void serviceLocalException(Throwable error) {
        log.info((Object)("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage()), error);
        ServiceSupport.dispose(this);
    }

    protected void addSubscription(DemandSubscription sub) throws IOException {
        if (sub != null) {
            this.localBroker.oneway(sub.getLocalInfo());
        }
    }

    protected void removeSubscription(DemandSubscription sub) throws IOException {
        if (sub != null) {
            this.subscriptionMapByLocalId.remove((Object)sub.getLocalInfo().getConsumerId());
            this.localBroker.oneway(sub.getLocalInfo().createRemoveCommand());
        }
    }

    protected DemandSubscription getDemandSubscription(MessageDispatch md) {
        return (DemandSubscription)this.subscriptionMapByLocalId.get((Object)md.getConsumerId());
    }

    protected Message configureMessage(MessageDispatch md) {
        Message message = md.getMessage().copy();
        message.setBrokerPath(this.appendToBrokerPath(message.getBrokerPath(), this.localBrokerPath));
        message.setProducerId(this.producerInfo.getProducerId());
        message.setDestination(md.getDestination());
        if (message.getOriginalTransactionId() == null) {
            message.setOriginalTransactionId(message.getTransactionId());
        }
        message.setTransactionId(null);
        message.evictMarshlledForm();
        return message;
    }

    protected void serviceLocalCommand(Command command) {
        if (!this.disposed) {
            boolean trace = log.isTraceEnabled();
            try {
                if (command.isMessageDispatch()) {
                    this.waitStarted();
                    final MessageDispatch md = (MessageDispatch)command;
                    DemandSubscription sub = (DemandSubscription)this.subscriptionMapByLocalId.get((Object)md.getConsumerId());
                    if (sub != null) {
                        Message message = this.configureMessage(md);
                        if (trace) {
                            log.trace((Object)("bridging " + this.localBrokerName + " -> " + this.remoteBrokerName + ": " + message));
                        }
                        if (!message.isResponseRequired()) {
                            this.remoteBroker.oneway(message);
                            this.localBroker.oneway(new MessageAck(md, 2, 1));
                        } else {
                            ResponseCallback callback = new ResponseCallback(){

                                public void onCompletion(FutureResponse future) {
                                    try {
                                        Response response = future.getResult();
                                        if (response.isException()) {
                                            ExceptionResponse er = (ExceptionResponse)response;
                                            DemandForwardingBridgeSupport.this.serviceLocalException(er.getException());
                                        } else {
                                            DemandForwardingBridgeSupport.this.localBroker.oneway(new MessageAck(md, 2, 1));
                                        }
                                    }
                                    catch (IOException e) {
                                        DemandForwardingBridgeSupport.this.serviceLocalException(e);
                                    }
                                }
                            };
                            this.remoteBroker.asyncRequest(message, callback);
                        }
                    }
                } else if (command.isBrokerInfo()) {
                    this.serviceLocalBrokerInfo(command);
                } else if (command.isShutdownInfo()) {
                    log.info((Object)(this.localBrokerName + " Shutting down"));
                    this.shutDown = true;
                    this.doStop();
                } else {
                    switch (command.getDataStructureType()) {
                        case 1: {
                            break;
                        }
                        default: {
                            log.warn((Object)("Unexpected local command: " + command));
                        }
                    }
                }
            }
            catch (Exception e) {
                this.serviceLocalException(e);
            }
        }
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public ActiveMQDestination[] getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    public void setDynamicallyIncludedDestinations(ActiveMQDestination[] dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public ActiveMQDestination[] getExcludedDestinations() {
        return this.excludedDestinations;
    }

    public void setExcludedDestinations(ActiveMQDestination[] excludedDestinations) {
        this.excludedDestinations = excludedDestinations;
    }

    public ActiveMQDestination[] getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    public void setStaticallyIncludedDestinations(ActiveMQDestination[] staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public ActiveMQDestination[] getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(ActiveMQDestination[] durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    public String getLocalBrokerName() {
        return this.localBrokerName;
    }

    public void setLocalBrokerName(String localBrokerName) {
        this.localBrokerName = localBrokerName;
    }

    public Transport getLocalBroker() {
        return this.localBroker;
    }

    public Transport getRemoteBroker() {
        return this.remoteBroker;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDecreaseNetworkConsumerPriority() {
        return this.decreaseNetworkConsumerPriority;
    }

    public void setDecreaseNetworkConsumerPriority(boolean decreaseNetworkConsumerPriority) {
        this.decreaseNetworkConsumerPriority = decreaseNetworkConsumerPriority;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId[] pathsToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return pathsToAppend;
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + pathsToAppend.length];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        System.arraycopy(pathsToAppend, 0, rc, brokerPath.length, pathsToAppend.length);
        return rc;
    }

    protected BrokerId[] appendToBrokerPath(BrokerId[] brokerPath, BrokerId idToAppend) {
        if (brokerPath == null || brokerPath.length == 0) {
            return new BrokerId[]{idToAppend};
        }
        BrokerId[] rc = new BrokerId[brokerPath.length + 1];
        System.arraycopy(brokerPath, 0, rc, 0, brokerPath.length);
        rc[brokerPath.length] = idToAppend;
        return rc;
    }

    protected boolean isPermissableDestination(ActiveMQDestination destination) {
        ActiveMQDestination match;
        int i;
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        ActiveMQDestination[] dests = this.excludedDestinations;
        if (dests != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                if (match == null || !filter.matches(match)) continue;
                return false;
            }
        }
        if ((dests = this.dynamicallyIncludedDestinations) != null && dests.length > 0) {
            for (i = 0; i < dests.length; ++i) {
                match = dests[i];
                if (match == null || !filter.matches(match)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void setupStaticDestinations() {
        ActiveMQDestination[] dests = this.staticallyIncludedDestinations;
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                ActiveMQDestination dest = dests[i];
                DemandSubscription sub = this.createDemandSubscription(dest);
                try {
                    this.addSubscription(sub);
                }
                catch (IOException e) {
                    log.error((Object)("Failed to add static destination " + dest), (Throwable)e);
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Forwarding messages for static destination: " + dest));
            }
        }
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        return this.doCreateDemandSubscription(info);
    }

    protected DemandSubscription doCreateDemandSubscription(ConsumerInfo info) throws IOException {
        DemandSubscription result = new DemandSubscription(info);
        result.getLocalInfo().setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        if (this.decreaseNetworkConsumerPriority) {
            byte priority = -5;
            if (priority > -128 && info.getBrokerPath() != null && info.getBrokerPath().length > 1) {
                priority = (byte)(priority - (info.getBrokerPath().length + 1));
            }
            result.getLocalInfo().setPriority(priority);
        }
        this.configureDemandSubscription(info, result);
        return result;
    }

    protected DemandSubscription createDemandSubscription(ActiveMQDestination destination) {
        ConsumerInfo info = new ConsumerInfo();
        info.setDestination(destination);
        info.setConsumerId(new ConsumerId(this.localSessionInfo.getSessionId(), this.consumerIdGenerator.getNextSequenceId()));
        DemandSubscription result = new DemandSubscription(info);
        result.getLocalInfo().setPriority((byte)-5);
        return result;
    }

    protected void configureDemandSubscription(ConsumerInfo info, DemandSubscription sub) throws IOException {
        sub.getLocalInfo().setDispatchAsync(this.dispatchAsync);
        sub.getLocalInfo().setPrefetchSize(this.prefetchSize);
        this.subscriptionMapByLocalId.put((Object)sub.getLocalInfo().getConsumerId(), (Object)sub);
        this.subscriptionMapByRemoteId.put((Object)sub.getRemoteInfo().getConsumerId(), (Object)sub);
        sub.getLocalInfo().setAdditionalPredicate(this.createNetworkBridgeFilter(info));
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        DemandSubscription sub = (DemandSubscription)this.subscriptionMapByRemoteId.remove((Object)id);
        if (sub != null) {
            this.removeSubscription(sub);
            if (log.isTraceEnabled()) {
                log.trace((Object)("removing sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + sub.getRemoteInfo()));
            }
        }
    }

    protected void waitStarted() throws InterruptedException {
        this.startedLatch.await();
    }

    protected void clearDownSubscriptions() {
    }

    protected abstract NetworkBridgeFilter createNetworkBridgeFilter(ConsumerInfo var1) throws IOException;

    protected abstract void serviceLocalBrokerInfo(Command var1) throws InterruptedException;

    protected abstract void addRemoteBrokerToBrokerPath(ConsumerInfo var1) throws IOException;

    protected abstract void serviceRemoteBrokerInfo(Command var1) throws IOException;

    protected abstract BrokerId[] getRemoteBrokerPath();

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

