/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.Bridge;
import org.apache.activemq.network.ConnectionFilter;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NetworkConnector
extends ServiceSupport {
    protected static final Log log = LogFactory.getLog((Class)NetworkConnector.class);
    protected URI localURI;
    private String brokerName = "localhost";
    private Set durableDestinations;
    protected boolean failover = false;
    private List excludedDestinations = new CopyOnWriteArrayList();
    private List dynamicallyIncludedDestinations = new CopyOnWriteArrayList();
    private List staticallyIncludedDestinations = new CopyOnWriteArrayList();
    protected boolean dynamicOnly = false;
    protected boolean conduitSubscriptions = true;
    private boolean decreaseNetworkConsumerPriority;
    private int networkTTL = 1;
    private String name = "bridge";
    private int prefetchSize = 1000;
    private boolean dispatchAsync = true;
    private String userName;
    private String password;
    protected ConnectionFilter connectionFilter;

    public NetworkConnector() {
    }

    public NetworkConnector(URI localURI) {
        this.localURI = localURI;
    }

    public URI getLocalUri() throws URISyntaxException {
        return this.localURI;
    }

    public void setLocalUri(URI localURI) {
        this.localURI = localURI;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.createName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public Set getDurableDestinations() {
        return this.durableDestinations;
    }

    public void setDurableDestinations(Set durableDestinations) {
        this.durableDestinations = durableDestinations;
    }

    public boolean isDynamicOnly() {
        return this.dynamicOnly;
    }

    public void setDynamicOnly(boolean dynamicOnly) {
        this.dynamicOnly = dynamicOnly;
    }

    public boolean isConduitSubscriptions() {
        return this.conduitSubscriptions;
    }

    public void setConduitSubscriptions(boolean conduitSubscriptions) {
        this.conduitSubscriptions = conduitSubscriptions;
    }

    public boolean isDecreaseNetworkConsumerPriority() {
        return this.decreaseNetworkConsumerPriority;
    }

    public void setDecreaseNetworkConsumerPriority(boolean decreaseNetworkConsumerPriority) {
        this.decreaseNetworkConsumerPriority = decreaseNetworkConsumerPriority;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public List getExcludedDestinations() {
        return this.excludedDestinations;
    }

    public void setExcludedDestinations(List exludedDestinations) {
        this.excludedDestinations = exludedDestinations;
    }

    public void addExcludedDestination(ActiveMQDestination destiantion) {
        this.excludedDestinations.add(destiantion);
    }

    public List getStaticallyIncludedDestinations() {
        return this.staticallyIncludedDestinations;
    }

    public void setStaticallyIncludedDestinations(List staticallyIncludedDestinations) {
        this.staticallyIncludedDestinations = staticallyIncludedDestinations;
    }

    public void addStaticallyIncludedDestination(ActiveMQDestination destiantion) {
        this.staticallyIncludedDestinations.add(destiantion);
    }

    public List getDynamicallyIncludedDestinations() {
        return this.dynamicallyIncludedDestinations;
    }

    public void setDynamicallyIncludedDestinations(List dynamicallyIncludedDestinations) {
        this.dynamicallyIncludedDestinations = dynamicallyIncludedDestinations;
    }

    public void addDynamicallyIncludedDestination(ActiveMQDestination destiantion) {
        this.dynamicallyIncludedDestinations.add(destiantion);
    }

    protected Bridge configureBridge(DemandForwardingBridgeSupport result) {
        result.setLocalBrokerName(this.getBrokerName());
        result.setName(this.getBrokerName());
        result.setNetworkTTL(this.getNetworkTTL());
        result.setUserName(this.userName);
        result.setPassword(this.password);
        result.setPrefetchSize(this.prefetchSize);
        result.setDispatchAsync(this.dispatchAsync);
        result.setDecreaseNetworkConsumerPriority(this.isDecreaseNetworkConsumerPriority());
        List destsList = this.getDynamicallyIncludedDestinations();
        ActiveMQDestination[] dests = destsList.toArray(new ActiveMQDestination[destsList.size()]);
        result.setDynamicallyIncludedDestinations(dests);
        destsList = this.getExcludedDestinations();
        dests = destsList.toArray(new ActiveMQDestination[destsList.size()]);
        result.setExcludedDestinations(dests);
        destsList = this.getStaticallyIncludedDestinations();
        dests = destsList.toArray(new ActiveMQDestination[destsList.size()]);
        result.setStaticallyIncludedDestinations(dests);
        if (this.durableDestinations != null) {
            ActiveMQDestination[] dest = new ActiveMQDestination[this.durableDestinations.size()];
            dest = this.durableDestinations.toArray(dest);
            result.setDurableDestinations(dest);
        }
        return result;
    }

    protected abstract String createName();

    protected void doStart() throws Exception {
        if (this.localURI == null) {
            throw new IllegalStateException("You must configure the 'localURI' property");
        }
        log.info((Object)("Network Connector " + this.getName() + " Started"));
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        log.info((Object)("Network Connector " + this.getName() + " Stopped"));
    }

    protected Transport createLocalTransport() throws Exception {
        return TransportFactory.connect(this.localURI);
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public ConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public void setConnectionFilter(ConnectionFilter connectionFilter) {
        this.connectionFilter = connectionFilter;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

