/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.activeio.adapter.PacketToInputStream;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.ByteSequence;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.PacketData;
import org.apache.activeio.util.ByteArrayOutputStream;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MarshallAware;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.DataStreamMarshaller;
import org.apache.activemq.util.ClassLoading;
import org.apache.activemq.util.IdGenerator;

public final class OpenWireFormat
implements WireFormat {
    static final byte NULL_TYPE = 0;
    private static final int MARSHAL_CACHE_SIZE = 16383;
    private static final int MARSHAL_CACHE_PREFERED_SIZE = 16283;
    private DataStreamMarshaller[] dataMarshallers;
    private int version;
    private boolean stackTraceEnabled = false;
    private boolean tcpNoDelayEnabled = false;
    private boolean cacheEnabled = false;
    private boolean tightEncodingEnabled = false;
    private boolean sizePrefixDisabled = false;
    private HashMap marshallCacheMap = new HashMap();
    private short nextMarshallCacheIndex = 0;
    private short nextMarshallCacheEvictionIndex = 0;
    private DataStructure[] marshallCache = new DataStructure[16383];
    private DataStructure[] unmarshallCache = new DataStructure[16383];
    private WireFormatInfo preferedWireFormatInfo;
    static IdGenerator g = new IdGenerator();
    String id = g.generateId();

    public OpenWireFormat() {
        this(1);
    }

    public OpenWireFormat(int i) {
        this.setVersion(i);
    }

    public int hashCode() {
        return this.version ^ (this.cacheEnabled ? 0x10000000 : 0x20000000) ^ (this.stackTraceEnabled ? 0x1000000 : 0x2000000) ^ (this.tightEncodingEnabled ? 0x100000 : 0x200000) ^ (this.sizePrefixDisabled ? 65536 : 131072);
    }

    public OpenWireFormat copy() {
        OpenWireFormat answer = new OpenWireFormat();
        answer.version = this.version;
        answer.stackTraceEnabled = this.stackTraceEnabled;
        answer.tcpNoDelayEnabled = this.tcpNoDelayEnabled;
        answer.cacheEnabled = this.cacheEnabled;
        answer.tightEncodingEnabled = this.tightEncodingEnabled;
        answer.sizePrefixDisabled = this.sizePrefixDisabled;
        answer.preferedWireFormatInfo = this.preferedWireFormatInfo;
        return answer;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        OpenWireFormat o = (OpenWireFormat)object;
        return o.stackTraceEnabled == this.stackTraceEnabled && o.cacheEnabled == this.cacheEnabled && o.version == this.version && o.tightEncodingEnabled == this.tightEncodingEnabled && o.sizePrefixDisabled == this.sizePrefixDisabled;
    }

    public String toString() {
        return "OpenWireFormat{version=" + this.version + ", cacheEnabled=" + this.cacheEnabled + ", stackTraceEnabled=" + this.stackTraceEnabled + ", tightEncodingEnabled=" + this.tightEncodingEnabled + ", sizePrefixDisabled=" + this.sizePrefixDisabled + "}";
    }

    public int getVersion() {
        return this.version;
    }

    public Packet marshal(Object command) throws IOException {
        if (this.cacheEnabled) {
            this.runMarshallCacheEvictionSweep();
        }
        MarshallAware ma = null;
        if (!this.cacheEnabled && ((DataStructure)command).isMarshallAware()) {
            ma = (MarshallAware)command;
        }
        ByteSequence sequence = null;
        if (ma != null) {
            sequence = ma.getCachedMarshalledForm(this);
        }
        if (sequence == null) {
            int size = 1;
            if (command != null) {
                DataStructure c = (DataStructure)command;
                byte type = c.getDataStructureType();
                DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
                if (dsm == null) {
                    throw new IOException("Unknown data type: " + type);
                }
                if (this.tightEncodingEnabled) {
                    BooleanStream bs = new BooleanStream();
                    size += dsm.tightMarshal1(this, c, bs);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(size += bs.marshalledSize());
                    DataOutputStream ds = new DataOutputStream((OutputStream)baos);
                    if (!this.sizePrefixDisabled) {
                        ds.writeInt(size);
                    }
                    ds.writeByte(type);
                    bs.marshal(ds);
                    dsm.tightMarshal2(this, c, ds, bs);
                    ds.close();
                    sequence = baos.toByteSequence();
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream ds = new DataOutputStream((OutputStream)baos);
                    if (!this.sizePrefixDisabled) {
                        ds.writeInt(0);
                    }
                    ds.writeByte(type);
                    dsm.looseMarshal(this, c, ds);
                    ds.close();
                    sequence = baos.toByteSequence();
                    if (!this.sizePrefixDisabled) {
                        size = sequence.getLength() - 4;
                        ByteArrayPacket packet = new ByteArrayPacket(sequence);
                        PacketData.writeIntBig((Packet)packet, (int)size);
                    }
                }
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(5);
                DataOutputStream daos = new DataOutputStream((OutputStream)baos);
                daos.writeInt(size);
                daos.writeByte(0);
                daos.close();
                sequence = baos.toByteSequence();
            }
            if (ma != null) {
                ma.setCachedMarshalledForm(this, sequence);
            }
        }
        return new ByteArrayPacket(sequence);
    }

    public Object unmarshal(Packet packet) throws IOException {
        ByteSequence sequence = packet.asByteSequence();
        DataInputStream dis = new DataInputStream((InputStream)new PacketToInputStream(packet));
        if (!this.sizePrefixDisabled) {
            int size = dis.readInt();
            if (sequence.getLength() - 4 != size) {
                // empty if block
            }
        }
        Object command = this.doUnmarshal(dis);
        if (!this.cacheEnabled && ((DataStructure)command).isMarshallAware()) {
            ((MarshallAware)command).setCachedMarshalledForm(this, sequence);
        }
        return command;
    }

    public void marshal(Object o, DataOutputStream dataOut) throws IOException {
        if (this.cacheEnabled) {
            this.runMarshallCacheEvictionSweep();
        }
        int size = 1;
        if (o != null) {
            DataStructure c = (DataStructure)o;
            byte type = c.getDataStructureType();
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            if (this.tightEncodingEnabled) {
                BooleanStream bs = new BooleanStream();
                size += dsm.tightMarshal1(this, c, bs);
                dataOut.writeInt(size += bs.marshalledSize());
                dataOut.writeByte(type);
                bs.marshal(dataOut);
                dsm.tightMarshal2(this, c, dataOut, bs);
            } else {
                DataOutputStream looseOut = dataOut;
                ByteArrayOutputStream baos = null;
                if (!this.sizePrefixDisabled) {
                    baos = new ByteArrayOutputStream();
                    looseOut = new DataOutputStream((OutputStream)baos);
                }
                looseOut.writeByte(type);
                dsm.looseMarshal(this, c, looseOut);
                if (!this.sizePrefixDisabled) {
                    looseOut.close();
                    ByteSequence sequence = baos.toByteSequence();
                    dataOut.writeInt(sequence.getLength() - 4);
                    dataOut.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
                }
            }
        } else {
            dataOut.writeInt(size);
            dataOut.writeByte(0);
        }
    }

    public Object unmarshal(DataInputStream dis) throws IOException {
        if (!this.sizePrefixDisabled) {
            dis.readInt();
        }
        return this.doUnmarshal(dis);
    }

    public int tightMarshal1(Object o, BooleanStream bs) throws IOException {
        int size = 1;
        if (o != null) {
            DataStructure c = (DataStructure)o;
            byte type = c.getDataStructureType();
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            size += dsm.tightMarshal1(this, c, bs);
            size += bs.marshalledSize();
        }
        return size;
    }

    public void tightMarshal2(Object o, DataOutputStream ds, BooleanStream bs) throws IOException {
        if (this.cacheEnabled) {
            this.runMarshallCacheEvictionSweep();
        }
        if (o != null) {
            DataStructure c = (DataStructure)o;
            byte type = c.getDataStructureType();
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            ds.writeByte(type);
            bs.marshal(ds);
            dsm.tightMarshal2(this, c, ds, bs);
        }
    }

    public void setVersion(int version) {
        Class mfClass;
        String mfName = "org.apache.activemq.openwire.v" + version + ".MarshallerFactory";
        try {
            mfClass = ClassLoading.loadClass(mfName, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid version: " + version + ", could not load " + mfName).initCause(e);
        }
        try {
            Method method = mfClass.getMethod("createMarshallerMap", OpenWireFormat.class);
            this.dataMarshallers = (DataStreamMarshaller[])method.invoke(null, this);
        }
        catch (Throwable e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid version: " + version + ", " + mfName + " does not properly implement the createMarshallerMap method.").initCause(e);
        }
        this.version = version;
    }

    public Object doUnmarshal(DataInputStream dis) throws IOException {
        byte dataType = dis.readByte();
        if (dataType != 0) {
            DataStreamMarshaller dsm = this.dataMarshallers[dataType & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + dataType);
            }
            DataStructure data = dsm.createObject();
            if (this.tightEncodingEnabled) {
                BooleanStream bs = new BooleanStream();
                bs.unmarshal(dis);
                dsm.tightUnmarshal(this, data, dis, bs);
            } else {
                dsm.looseUnmarshal(this, data, dis);
            }
            return data;
        }
        return null;
    }

    public int tightMarshalNestedObject1(DataStructure o, BooleanStream bs) throws IOException {
        byte type;
        DataStreamMarshaller dsm;
        bs.writeBoolean(o != null);
        if (o == null) {
            return 0;
        }
        if (o.isMarshallAware()) {
            MarshallAware ma = (MarshallAware)((Object)o);
            ByteSequence sequence = ma.getCachedMarshalledForm(this);
            bs.writeBoolean(sequence != null);
            if (sequence != null) {
                return 1 + sequence.getLength();
            }
        }
        if ((dsm = this.dataMarshallers[(type = o.getDataStructureType()) & 0xFF]) == null) {
            throw new IOException("Unknown data type: " + type);
        }
        return 1 + dsm.tightMarshal1(this, o, bs);
    }

    public void tightMarshalNestedObject2(DataStructure o, DataOutputStream ds, BooleanStream bs) throws IOException {
        if (!bs.readBoolean()) {
            return;
        }
        byte type = o.getDataStructureType();
        ds.writeByte(type);
        if (o.isMarshallAware() && bs.readBoolean()) {
            MarshallAware ma = (MarshallAware)((Object)o);
            ByteSequence sequence = ma.getCachedMarshalledForm(this);
            ds.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
        } else {
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            dsm.tightMarshal2(this, o, ds, bs);
        }
    }

    public DataStructure tightUnmarshalNestedObject(DataInputStream dis, BooleanStream bs) throws IOException {
        if (bs.readBoolean()) {
            byte dataType = dis.readByte();
            DataStreamMarshaller dsm = this.dataMarshallers[dataType & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + dataType);
            }
            DataStructure data = dsm.createObject();
            if (data.isMarshallAware() && bs.readBoolean()) {
                dis.readInt();
                dis.readByte();
                BooleanStream bs2 = new BooleanStream();
                bs2.unmarshal(dis);
                dsm.tightUnmarshal(this, data, dis, bs2);
            } else {
                dsm.tightUnmarshal(this, data, dis, bs);
            }
            return data;
        }
        return null;
    }

    public DataStructure looseUnmarshalNestedObject(DataInputStream dis) throws IOException {
        if (dis.readBoolean()) {
            byte dataType = dis.readByte();
            DataStreamMarshaller dsm = this.dataMarshallers[dataType & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + dataType);
            }
            DataStructure data = dsm.createObject();
            dsm.looseUnmarshal(this, data, dis);
            return data;
        }
        return null;
    }

    public void looseMarshalNestedObject(DataStructure o, DataOutputStream dataOut) throws IOException {
        dataOut.writeBoolean(o != null);
        if (o != null) {
            byte type = o.getDataStructureType();
            dataOut.writeByte(type);
            DataStreamMarshaller dsm = this.dataMarshallers[type & 0xFF];
            if (dsm == null) {
                throw new IOException("Unknown data type: " + type);
            }
            dsm.looseMarshal(this, o, dataOut);
        }
    }

    public void runMarshallCacheEvictionSweep() {
        while (this.marshallCacheMap.size() > 16283) {
            this.marshallCacheMap.remove(this.marshallCache[this.nextMarshallCacheEvictionIndex]);
            this.marshallCache[this.nextMarshallCacheEvictionIndex] = null;
            this.nextMarshallCacheEvictionIndex = (short)(this.nextMarshallCacheEvictionIndex + 1);
            if (this.nextMarshallCacheEvictionIndex < 16383) continue;
            this.nextMarshallCacheEvictionIndex = 0;
        }
    }

    public Short getMarshallCacheIndex(DataStructure o) {
        return (Short)this.marshallCacheMap.get(o);
    }

    public Short addToMarshallCache(DataStructure o) {
        short s = this.nextMarshallCacheIndex;
        this.nextMarshallCacheIndex = (short)(s + 1);
        short i = s;
        if (this.nextMarshallCacheIndex >= 16383) {
            this.nextMarshallCacheIndex = 0;
        }
        if (this.marshallCacheMap.size() < 16383) {
            this.marshallCache[i] = o;
            Short index = new Short(i);
            this.marshallCacheMap.put(o, index);
            return index;
        }
        return new Short(-1);
    }

    public void setInUnmarshallCache(short index, DataStructure o) {
        if (index == -1) {
            return;
        }
        this.unmarshallCache[index] = o;
    }

    public DataStructure getFromUnmarshallCache(short index) {
        return this.unmarshallCache[index];
    }

    public void setStackTraceEnabled(boolean b) {
        this.stackTraceEnabled = b;
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public boolean isTcpNoDelayEnabled() {
        return this.tcpNoDelayEnabled;
    }

    public void setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) {
        this.tcpNoDelayEnabled = tcpNoDelayEnabled;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isTightEncodingEnabled() {
        return this.tightEncodingEnabled;
    }

    public void setTightEncodingEnabled(boolean tightEncodingEnabled) {
        this.tightEncodingEnabled = tightEncodingEnabled;
    }

    public boolean isSizePrefixDisabled() {
        return this.sizePrefixDisabled;
    }

    public void setSizePrefixDisabled(boolean prefixPacketSize) {
        this.sizePrefixDisabled = prefixPacketSize;
    }

    public void setPreferedWireFormatInfo(WireFormatInfo info) {
        this.preferedWireFormatInfo = info;
    }

    public WireFormatInfo getPreferedWireFormatInfo() {
        return this.preferedWireFormatInfo;
    }

    public void renegociatWireFormat(WireFormatInfo info) throws IOException {
        if (this.preferedWireFormatInfo == null) {
            throw new IllegalStateException("Wireformat cannot not be renegociated.");
        }
        this.setVersion(Math.max(this.preferedWireFormatInfo.getVersion(), info.getVersion()));
        this.stackTraceEnabled = info.isStackTraceEnabled() && this.preferedWireFormatInfo.isStackTraceEnabled();
        this.tcpNoDelayEnabled = info.isTcpNoDelayEnabled() && this.preferedWireFormatInfo.isTcpNoDelayEnabled();
        this.cacheEnabled = info.isCacheEnabled() && this.preferedWireFormatInfo.isCacheEnabled();
        this.tightEncodingEnabled = info.isTightEncodingEnabled() && this.preferedWireFormatInfo.isTightEncodingEnabled();
        this.sizePrefixDisabled = info.isSizePrefixDisabled() && this.preferedWireFormatInfo.isSizePrefixDisabled();
    }
}

