/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.state;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.state.SessionState;

public class ConnectionState {
    final ConnectionInfo info;
    private final ConcurrentHashMap sessions = new ConcurrentHashMap();
    private final List tempDestinations = Collections.synchronizedList(new ArrayList());

    public ConnectionState(ConnectionInfo info) {
        this.info = info;
        this.addSession(new SessionInfo(info, -1L));
    }

    public String toString() {
        return this.info.toString();
    }

    public void addTempDestination(DestinationInfo info) {
        this.tempDestinations.add(info);
    }

    public void removeTempDestination(ActiveMQDestination destination) {
        Iterator iter = this.tempDestinations.iterator();
        while (iter.hasNext()) {
            DestinationInfo di = (DestinationInfo)iter.next();
            if (!di.getDestination().equals(destination)) continue;
            iter.remove();
        }
    }

    public void addSession(SessionInfo info) {
        this.sessions.put((Object)info.getSessionId(), (Object)new SessionState(info));
    }

    public SessionState removeSession(SessionId id) {
        return (SessionState)this.sessions.remove((Object)id);
    }

    public SessionState getSessionState(SessionId id) {
        return (SessionState)this.sessions.get((Object)id);
    }

    public ConnectionInfo getInfo() {
        return this.info;
    }

    public Set getSessionIds() {
        return this.sessions.keySet();
    }

    public List getTempDesinations() {
        return this.tempDestinations;
    }

    public Collection getSessionStates() {
        return this.sessions.values();
    }
}

