/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.File;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.active.JournalImpl;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.activemq.store.journal.QuickJournalPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class DefaultPersistenceAdapterFactory
implements PersistenceAdapterFactory {
    private int journalLogFileSize = 0x1400000;
    private int journalLogFiles = 2;
    private File dataDirectory;
    private DataSource dataSource;
    private TaskRunnerFactory taskRunnerFactory;
    private Journal journal;
    private boolean useJournal = true;
    private boolean useQuickJournal = false;
    private File journalArchiveDirectory;
    private JDBCPersistenceAdapter jdbcPersistenceAdapter = new JDBCPersistenceAdapter();

    public PersistenceAdapter createPersistenceAdapter() throws IOException {
        File dataDirectory = this.getDataDirectory();
        this.jdbcPersistenceAdapter.setDataSource(this.getDataSource());
        if (!this.useJournal) {
            return this.jdbcPersistenceAdapter;
        }
        if (this.useQuickJournal) {
            return new QuickJournalPersistenceAdapter(this.getJournal(), this.jdbcPersistenceAdapter, this.getTaskRunnerFactory());
        }
        return new JournalPersistenceAdapter(this.getJournal(), this.jdbcPersistenceAdapter, this.getTaskRunnerFactory());
    }

    public File getDataDirectory() {
        if (this.dataDirectory == null) {
            this.dataDirectory = new File("activemq-data");
        }
        return this.dataDirectory;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public int getJournalLogFiles() {
        return this.journalLogFiles;
    }

    public void setJournalLogFiles(int journalLogFiles) {
        this.journalLogFiles = journalLogFiles;
    }

    public int getJournalLogFileSize() {
        return this.journalLogFileSize;
    }

    public void setJournalLogFileSize(int journalLogFileSize) {
        this.journalLogFileSize = journalLogFileSize;
    }

    public DataSource getDataSource() throws IOException {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCPersistenceAdapter getJdbcAdapter() {
        return this.jdbcPersistenceAdapter;
    }

    public void setJdbcAdapter(JDBCPersistenceAdapter jdbcAdapter) {
        this.jdbcPersistenceAdapter = jdbcAdapter;
    }

    public boolean isUseJournal() {
        return this.useJournal;
    }

    public void setUseJournal(boolean useJournal) {
        this.useJournal = useJournal;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory();
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.createJournal();
        }
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public File getJournalArchiveDirectory() {
        if (this.journalArchiveDirectory == null && this.useQuickJournal) {
            this.journalArchiveDirectory = new File(this.getDataDirectory(), "journal");
        }
        return this.journalArchiveDirectory;
    }

    public void setJournalArchiveDirectory(File journalArchiveDirectory) {
        this.journalArchiveDirectory = journalArchiveDirectory;
    }

    public boolean isUseQuickJournal() {
        return this.useQuickJournal;
    }

    public void setUseQuickJournal(boolean useQuickJournal) {
        this.useQuickJournal = useQuickJournal;
    }

    public JDBCAdapter getAdapter() throws IOException {
        return this.jdbcPersistenceAdapter.getAdapter();
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.jdbcPersistenceAdapter.setAdapter(adapter);
    }

    public Statements getStatements() {
        return this.jdbcPersistenceAdapter.getStatements();
    }

    public void setStatements(Statements statements) {
        this.jdbcPersistenceAdapter.setStatements(statements);
    }

    protected DataSource createDataSource() throws IOException {
        System.setProperty("derby.system.home", this.getDataDirectory().getCanonicalPath());
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        System.setProperty("derby.storage.pageCacheSize", "100");
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDatabaseName("derbydb");
        ds.setCreateDatabase("create");
        return ds;
    }

    protected void createJournal() throws IOException {
        File journalDir = new File(this.getDataDirectory(), "journal").getCanonicalFile();
        this.journal = new JournalImpl(journalDir, this.journalLogFiles, this.journalLogFileSize, this.getJournalArchiveDirectory());
    }
}

