/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.IOExceptionSupport;

public class JDBCMessageStore
implements MessageStore {
    protected final WireFormat wireFormat;
    protected final ActiveMQDestination destination;
    protected final JDBCAdapter adapter;
    protected final JDBCPersistenceAdapter persistenceAdapter;

    public JDBCMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQDestination destination) {
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.wireFormat = wireFormat;
        this.destination = destination;
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        byte[] data;
        try {
            Packet packet = this.wireFormat.marshal((Object)message);
            data = packet.sliceAsBytes();
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to broker message: " + message.getMessageId() + " in container: " + e, e);
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doAddMessage(c, message.getMessageId(), this.destination, data, message.getExpiration());
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + message.getMessageId() + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doAddMessageReference(c, messageId, this.destination, expirationTime, messageRef);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public Message getMessage(MessageId messageId) throws IOException {
        long id = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            Message answer;
            byte[] data = this.adapter.doGetMessage(c, id);
            if (data == null) {
                Message message = null;
                return message;
            }
            Message message = answer = (Message)this.wireFormat.unmarshal((Packet)new ByteArrayPacket(data));
            return message;
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public String getMessageReference(MessageId messageId) throws IOException {
        long id = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            String string = this.adapter.doGetMessageReference(c, id);
            return string;
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + messageId + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        long seq = ack.getLastMessageId().getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doRemoveMessage(c, seq);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker message: " + ack.getLastMessageId() + " in container: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void recover(final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doRecover(c, this.destination, new JDBCMessageRecoveryListener(){

                public void recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCMessageStore.this.wireFormat.unmarshal((Packet)new ByteArrayPacket(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    listener.recoverMessage(msg);
                }

                public void recoverMessageReference(String reference) throws Exception {
                    listener.recoverMessageReference(reference);
                }

                public void finished() {
                    listener.finished();
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to recover container. Reason: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doRemoveAllMessages(c, this.destination);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to broker remove all messages: " + e, e);
        }
        finally {
            c.close();
        }
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setUsageManager(UsageManager usageManager) {
    }
}

