/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.activemq.thread.DedicatedTaskRunner;
import org.apache.activemq.thread.PooledTaskRunner;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;

public class TaskRunnerFactory {
    private Executor executor;
    private int maxIterationsPerRun;
    private String name;
    private int priority;
    private boolean daemon;

    public TaskRunnerFactory() {
        this("ActiveMQ Task", 5, true, 1000);
    }

    public TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun) {
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
        this.maxIterationsPerRun = maxIterationsPerRun;
        this.executor = "true".equals(System.getProperty("org.apache.activemq.UseDedicatedTaskRunner")) ? null : this.createDefaultExecutor();
    }

    public TaskRunner createTaskRunner(Task task, String name) {
        if (this.executor != null) {
            return new PooledTaskRunner(this.executor, task, this.maxIterationsPerRun);
        }
        return new DedicatedTaskRunner(task, name, this.priority, this.daemon);
    }

    protected Executor createDefaultExecutor() {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, TaskRunnerFactory.this.name);
                thread.setDaemon(TaskRunnerFactory.this.daemon);
                thread.setPriority(TaskRunnerFactory.this.priority);
                return thread;
            }
        });
        rc.allowCoreThreadTimeOut(true);
        return rc;
    }
}

