/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.activeio.util.ByteArrayInputStream;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.LastPartialCommand;
import org.apache.activemq.command.PartialCommand;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandJoiner
extends TransportFilter {
    private static final Log log = LogFactory.getLog((Class)CommandJoiner.class);
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private OpenWireFormat wireFormat;

    public CommandJoiner(Transport next, OpenWireFormat wireFormat) {
        super(next);
        this.wireFormat = wireFormat;
    }

    public void onCommand(Command command) {
        byte type = command.getDataStructureType();
        if (type == 60 || type == 61) {
            PartialCommand header = (PartialCommand)command;
            byte[] partialData = header.getData();
            try {
                this.out.write(partialData);
            }
            catch (IOException e) {
                this.getTransportListener().onException(e);
            }
            if (type == 61) {
                try {
                    byte[] fullData = this.out.toByteArray();
                    this.out.reset();
                    DataInputStream dataIn = new DataInputStream((InputStream)new ByteArrayInputStream(fullData));
                    Command completeCommand = (Command)this.wireFormat.unmarshal(dataIn);
                    LastPartialCommand lastCommand = (LastPartialCommand)command;
                    lastCommand.configure(completeCommand);
                    this.getTransportListener().onCommand(completeCommand);
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to unmarshal partial command: " + command));
                    this.getTransportListener().onException(e);
                }
            }
        } else {
            this.getTransportListener().onCommand(command);
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.out = null;
    }

    public String toString() {
        return this.next.toString();
    }
}

