/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InactivityMonitor
extends TransportFilter {
    private final Log log = LogFactory.getLog((Class)InactivityMonitor.class);
    private WireFormatInfo localWireFormatInfo;
    private WireFormatInfo remoteWireFormatInfo;
    private boolean monitorStarted = false;
    private final AtomicBoolean commandSent = new AtomicBoolean(false);
    private final AtomicBoolean inSend = new AtomicBoolean(false);
    private final AtomicBoolean commandReceived = new AtomicBoolean(true);
    private final AtomicBoolean inReceive = new AtomicBoolean(false);
    private final Runnable readChecker = new Runnable(){

        public void run() {
            InactivityMonitor.this.readCheck();
        }
    };
    private final Runnable writeChecker = new Runnable(){

        public void run() {
            InactivityMonitor.this.writeCheck();
        }
    };

    public InactivityMonitor(Transport next) {
        super(next);
    }

    public void stop() throws Exception {
        this.stopMonitorThreads();
        this.next.stop();
    }

    private void writeCheck() {
        if (this.inSend.get()) {
            this.log.debug((Object)"A send is in progress");
            return;
        }
        if (!this.commandSent.get()) {
            this.log.debug((Object)"No message sent since last write check, sending a KeepAliveInfo");
            try {
                this.next.oneway(new KeepAliveInfo());
            }
            catch (IOException e) {
                this.onException(e);
            }
        } else {
            this.log.debug((Object)"Message sent since last write check, resetting flag");
        }
        this.commandSent.set(false);
    }

    private void readCheck() {
        if (this.inReceive.get()) {
            this.log.debug((Object)"A receive is in progress");
            return;
        }
        if (!this.commandReceived.get()) {
            this.log.debug((Object)"No message received since last read check! ");
            this.onException(new InactivityIOException("Channel was inactive for too long."));
        } else {
            this.log.debug((Object)"Message received since last read check, resetting flag: ");
        }
        this.commandReceived.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Command command) {
        this.inReceive.set(true);
        try {
            if (command.isWireFormatInfo()) {
                InactivityMonitor inactivityMonitor = this;
                synchronized (inactivityMonitor) {
                    this.remoteWireFormatInfo = (WireFormatInfo)command;
                    try {
                        this.startMonitorThreads();
                    }
                    catch (IOException e) {
                        this.onException(e);
                    }
                }
            }
            this.getTransportListener().onCommand(command);
        }
        finally {
            this.inReceive.set(false);
            this.commandReceived.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Command command) throws IOException {
        this.inSend.set(true);
        this.commandSent.set(true);
        try {
            if (command.isWireFormatInfo()) {
                InactivityMonitor inactivityMonitor = this;
                synchronized (inactivityMonitor) {
                    this.localWireFormatInfo = (WireFormatInfo)command;
                    this.startMonitorThreads();
                }
            }
            this.next.oneway(command);
        }
        finally {
            this.inSend.set(false);
        }
    }

    public void onException(IOException error) {
        this.stopMonitorThreads();
        this.getTransportListener().onException(error);
    }

    private synchronized void startMonitorThreads() throws IOException {
        if (this.monitorStarted) {
            return;
        }
        if (this.localWireFormatInfo == null) {
            return;
        }
        if (this.remoteWireFormatInfo == null) {
            return;
        }
        long l = Math.min(this.localWireFormatInfo.getMaxInactivityDuration(), this.remoteWireFormatInfo.getMaxInactivityDuration());
        if (l > 0L) {
            Scheduler.executePeriodically(this.writeChecker, l / 2L);
            Scheduler.executePeriodically(this.readChecker, l);
            this.monitorStarted = true;
        }
    }

    private synchronized void stopMonitorThreads() {
        if (this.monitorStarted) {
            Scheduler.cancel(this.readChecker);
            Scheduler.cancel(this.writeChecker);
            this.monitorStarted = false;
        }
    }
}

