/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportLogger
extends TransportFilter {
    private static int lastId = 0;
    private final Log log;

    public TransportLogger(Transport next) {
        this(next, LogFactory.getLog((String)(TransportLogger.class.getName() + ":" + TransportLogger.getNextId())));
    }

    private static synchronized int getNextId() {
        return ++lastId;
    }

    public TransportLogger(Transport next, Log log) {
        super(next);
        this.log = log;
    }

    public void oneway(Command command) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("SENDING: " + command));
        }
        this.next.oneway(command);
    }

    public void onCommand(Command command) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RECEIVED: from: " + command.getFrom() + " : " + command));
        }
        this.getTransportListener().onCommand(command);
    }

    public void onException(IOException error) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RECEIVED Exception: " + error), (Throwable)error);
        }
        this.getTransportListener().onException(error);
    }

    public String toString() {
        return this.next.toString();
    }
}

