/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.activeio;

import java.io.IOException;
import java.net.SocketException;
import org.apache.activeio.command.AsyncCommandChannel;
import org.apache.activeio.command.CommandListener;
import org.apache.activeio.stream.sync.socket.SocketMetadata;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.management.CountStatisticImpl;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;

public class ActiveIOTransport
implements Transport {
    private AsyncCommandChannel commandChannel;
    private TransportListener transportListener;
    private long timeout = 2000L;
    private int minmumWireFormatVersion = 0;
    private long maxInactivityDuration = 60000L;
    private boolean trace = false;
    private long stopTimeout = 2000L;
    private CountStatisticImpl readCounter;
    private CountStatisticImpl writeCounter;

    public ActiveIOTransport(AsyncCommandChannel commandChannel) {
        this.commandChannel = commandChannel;
        this.commandChannel.setCommandListener(new CommandListener(){

            public void onCommand(Object command) {
                if (command.getClass() == (class$org$apache$activemq$command$WireFormatInfo == null ? (class$org$apache$activemq$command$WireFormatInfo = ActiveIOTransport.class$("org.apache.activemq.command.WireFormatInfo")) : class$org$apache$activemq$command$WireFormatInfo)) {
                    WireFormatInfo info = (WireFormatInfo)command;
                    try {
                        if (info.isTcpNoDelayEnabled()) {
                            ActiveIOTransport.this.enableTcpNodeDelay();
                        }
                    }
                    catch (IOException e) {
                        this.onError(e);
                    }
                }
                ActiveIOTransport.this.transportListener.onCommand((Command)command);
            }

            public void onError(Exception e) {
                if (e instanceof IOException) {
                    ActiveIOTransport.this.transportListener.onException((IOException)e);
                } else {
                    ActiveIOTransport.this.transportListener.onException((IOException)new IOException().initCause(e));
                }
            }
        });
    }

    private void enableTcpNodeDelay() throws SocketException {
        SocketMetadata sm = (SocketMetadata)this.commandChannel.getAdapter(SocketMetadata.class);
        if (sm != null) {
            sm.setTcpNoDelay(true);
        }
    }

    public void oneway(Command command) throws IOException {
        WireFormatInfo info;
        if (command.getClass() == WireFormatInfo.class && (info = (WireFormatInfo)command).isTcpNoDelayEnabled()) {
            this.enableTcpNodeDelay();
        }
        this.commandChannel.writeCommand((Object)command);
    }

    public FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void start() throws Exception {
        this.commandChannel.start();
    }

    public void stop() throws Exception {
        this.commandChannel.stop();
        this.commandChannel.dispose();
    }

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener listener) {
        this.transportListener = listener;
    }

    public AsyncCommandChannel getCommandChannel() {
        return this.commandChannel;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public int getMinmumWireFormatVersion() {
        return this.minmumWireFormatVersion;
    }

    public void setMinmumWireFormatVersion(int minmumWireFormatVersion) {
        this.minmumWireFormatVersion = minmumWireFormatVersion;
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setReadCounter(CountStatisticImpl readCounter) {
        this.readCounter = readCounter;
    }

    public void setWriteCounter(CountStatisticImpl writeCounter) {
        this.writeCounter = writeCounter;
    }

    public CountStatisticImpl getReadCounter() {
        return this.readCounter;
    }

    public CountStatisticImpl getWriteCounter() {
        return this.writeCounter;
    }
}

