/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.activeio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import org.apache.activeio.AcceptListener;
import org.apache.activeio.Channel;
import org.apache.activeio.ChannelFactory;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.command.WireFormatFactory;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.activeio.ActiveIOTransportFactory;

public class ActiveIOTransportServer
implements TransportServer {
    private AsyncChannelServer server;
    private TransportAcceptListener acceptListener;
    private WireFormatFactory wireFormatFactory = new OpenWireFormatFactory();
    private long stopTimeout = 2000L;
    protected static final Executor BROKER_CONNECTION_EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

        public Thread newThread(Runnable run) {
            Thread thread = new Thread(run);
            thread.setPriority(6);
            return thread;
        }
    });

    public ActiveIOTransportServer(URI location, final Map options) throws IOException {
        this.server = new ChannelFactory().bindAsyncChannel(location);
        this.server.setAcceptListener(new AcceptListener(){

            public void onAccept(Channel c) {
                if (ActiveIOTransportServer.this.acceptListener == null) {
                    c.dispose();
                } else {
                    WireFormat format = ActiveIOTransportServer.this.wireFormatFactory.createWireFormat();
                    ActiveIOTransportServer.this.acceptListener.onAccept(ActiveIOTransportFactory.configure(c, format, options, BROKER_CONNECTION_EXECUTOR));
                }
            }

            public void onAcceptError(IOException error) {
                if (ActiveIOTransportServer.this.acceptListener != null) {
                    ActiveIOTransportServer.this.acceptListener.onAcceptError(error);
                }
            }
        });
    }

    public void setAcceptListener(TransportAcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server.dispose();
    }

    public URI getConnectURI() {
        return this.server.getConnectURI();
    }

    public URI getBindURI() {
        return this.server.getBindURI();
    }

    public WireFormatFactory getWireFormatFactory() {
        return this.wireFormatFactory;
    }

    public void setWireFormatFactory(WireFormatFactory wireFormatFactory) {
        this.wireFormatFactory = wireFormatFactory;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }
}

