/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.activeio;

import java.io.IOException;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;
import org.apache.activemq.management.CountStatisticImpl;

public class ActivityMonitor
extends FilterAsyncChannel {
    final CountStatisticImpl writeCounter = new CountStatisticImpl("writeCounter", "The number of bytes written to the transport");
    final CountStatisticImpl readCounter = new CountStatisticImpl("readCoutner", "The number bytes written to the transport");

    public ActivityMonitor(AsyncChannel next) {
        super(next);
    }

    public void onPacket(Packet packet) {
        this.readCounter.add(packet.remaining());
        super.onPacket(packet);
    }

    public void write(Packet packet) throws IOException {
        this.writeCounter.add(packet.remaining());
        super.write(packet);
    }

    public CountStatisticImpl getWriteCounter() {
        return this.writeCounter;
    }

    public CountStatisticImpl getReadCounter() {
        return this.readCounter;
    }
}

