/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.activeio;

import java.io.IOException;
import org.apache.activeio.packet.AppendedPacket;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.PacketData;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;

public final class PacketAggregatingAsyncChannel
extends FilterAsyncChannel {
    private static final int HEADER_LENGTH = 4;
    Packet incompleteUpPacket;
    boolean headerLoaded;
    private int upPacketLength;

    public PacketAggregatingAsyncChannel(AsyncChannel next) {
        super(next);
    }

    public void onPacket(Packet packet) {
        try {
            if (packet == EOSPacket.EOS_PACKET) {
                this.channelListener.onPacket(packet);
                return;
            }
            if (this.incompleteUpPacket != null) {
                packet = AppendedPacket.join((Packet)this.incompleteUpPacket, (Packet)packet);
                this.incompleteUpPacket = null;
            }
            while (true) {
                if (!this.headerLoaded) {
                    boolean bl = this.headerLoaded = packet.remaining() >= 4;
                    if (this.headerLoaded) {
                        int pos = packet.position();
                        this.upPacketLength = PacketData.readIntBig((Packet)packet);
                        packet.position(pos);
                        if (this.upPacketLength < 0) {
                            throw new IOException("Up packet length was invalid: " + this.upPacketLength);
                        }
                        this.upPacketLength += 4;
                    }
                    if (!this.headerLoaded) break;
                }
                if (packet.remaining() < this.upPacketLength) break;
                int origLimit = packet.limit();
                packet.limit(this.upPacketLength);
                this.channelListener.onPacket(packet.slice());
                packet.position(this.upPacketLength);
                packet.limit(origLimit);
                packet = packet.slice();
                this.headerLoaded = false;
            }
            if (packet.hasRemaining()) {
                this.incompleteUpPacket = packet;
            }
        }
        catch (IOException e) {
            this.channelListener.onPacketError(e);
        }
    }
}

