/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;

class Commit
implements StompCommand {
    private StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    Commit(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        while (in.readByte() != 0) {
        }
        String user_tx_id = headers.getProperty("transaction");
        if (user_tx_id == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId tx_id = this.format.getTransactionId(user_tx_id);
        if (tx_id == null) {
            throw new ProtocolException(user_tx_id + " is an invalid transaction id");
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.format.getConnectionId());
        tx.setTransactionId(tx_id);
        tx.setType((byte)2);
        this.format.clearTransactionId(user_tx_id);
        return new CommandEnvelope(tx, headers);
    }
}

