/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.net.ProtocolException;
import javax.jms.Destination;
import org.apache.activemq.command.ActiveMQDestination;

class DestinationNamer {
    DestinationNamer() {
    }

    static ActiveMQDestination convert(String name) throws ProtocolException {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/queue/")) {
            String q_name = name.substring("/queue/".length(), name.length());
            return ActiveMQDestination.createDestination(q_name, (byte)1);
        }
        if (name.startsWith("/topic/")) {
            String t_name = name.substring("/topic/".length(), name.length());
            return ActiveMQDestination.createDestination(t_name, (byte)2);
        }
        throw new ProtocolException("Illegal destination name: [" + name + "] -- ActiveMQ TTMP destinations " + "must begine with /queue/ or /topic/");
    }

    static String convert(Destination d) {
        if (d == null) {
            return null;
        }
        ActiveMQDestination amq_d = (ActiveMQDestination)d;
        String p_name = amq_d.getPhysicalName();
        StringBuffer buffer = new StringBuffer();
        if (amq_d.isQueue()) {
            buffer.append("/queue/");
        }
        if (amq_d.isTopic()) {
            buffer.append("/topic/");
        }
        buffer.append(p_name);
        return buffer.toString();
    }
}

