/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;

class HeaderParser {
    HeaderParser() {
    }

    Properties parse(BufferedReader in) throws IOException {
        String line;
        Properties props = new Properties();
        while ((line = in.readLine()) != null && line.trim().length() > 0) {
            int seperator_index = line.indexOf(":");
            String name = line.substring(0, seperator_index).trim();
            String value = line.substring(seperator_index + 1, line.length()).trim();
            props.setProperty(name, value);
        }
        return props;
    }

    Properties parse(DataInput in) throws IOException {
        String line;
        Properties props = new Properties();
        while ((line = in.readLine()) != null && line.trim().length() > 0) {
            try {
                int seperator_index = line.indexOf(":");
                String name = line.substring(0, seperator_index).trim();
                String value = line.substring(seperator_index + 1, line.length()).trim();
                props.setProperty(name, value);
            }
            catch (Exception e) {
                throw new ProtocolException("Unable to parser header line [" + line + "]");
            }
        }
        return props;
    }
}

