/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.activeio.adapter.PacketInputStream;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.util.ByteArrayOutputStream;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.transport.stomp.AsyncHelper;
import org.apache.activemq.transport.stomp.CommandParser;
import org.apache.activemq.transport.stomp.FrameBuilder;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.ResponseListener;
import org.apache.activemq.transport.stomp.Subscription;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;

public class StompWireFormat
implements WireFormat {
    private static final IdGenerator connectionIdGenerator;
    private static int transactionIdCounter;
    private int version = 1;
    private final CommandParser commandParser = new CommandParser(this);
    private final HeaderParser headerParser = new HeaderParser();
    private final BlockingQueue pendingReadCommands = new LinkedBlockingQueue();
    private final BlockingQueue pendingWriteFrames = new LinkedBlockingQueue();
    private final List receiptListeners = new CopyOnWriteArrayList();
    private final Map subscriptionsByConsumerId = new ConcurrentHashMap();
    private final Map subscriptionsByName = new ConcurrentHashMap();
    private final DestinationMap subscriptionsByDestination = new DestinationMap();
    private final Map transactions = new ConcurrentHashMap();
    private final Map dispachedMap = new ConcurrentHashMap();
    private short lastCommandId;
    private final ConnectionId connectionId = new ConnectionId(connectionIdGenerator.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    boolean connected = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    void addResponseListener(ResponseListener listener) {
        this.receiptListeners.add(listener);
    }

    public Command readCommand(DataInput in) throws IOException, JMSException {
        Command pending = (Command)AsyncHelper.tryUntilNotInterrupted(new AsyncHelper.HelperWithReturn(){

            public Object cycle() throws InterruptedException {
                return StompWireFormat.this.pendingReadCommands.poll(0L, TimeUnit.MILLISECONDS);
            }
        });
        if (pending != null) {
            return pending;
        }
        try {
            Command command = this.commandParser.parse(in);
            this.addToPendingReadCommands(command);
            command = (Command)AsyncHelper.tryUntilNotInterrupted(new AsyncHelper.HelperWithReturn(){

                public Object cycle() throws InterruptedException {
                    return StompWireFormat.this.pendingReadCommands.poll(0L, TimeUnit.MILLISECONDS);
                }
            });
            if (!this.connected && command.getDataStructureType() != 3) {
                throw new IOException("Not yet connected.");
            }
            return command;
        }
        catch (ProtocolException e) {
            this.sendError(e.getMessage());
            return FlushCommand.COMMAND;
        }
    }

    public Command writeCommand(Command packet, DataOutput out) throws IOException, JMSException {
        this.flushPendingFrames(out);
        if (packet == null) {
            return null;
        }
        if (packet.getDataStructureType() == 30) {
            if (!$assertionsDisabled && !(packet instanceof Response)) {
                throw new AssertionError();
            }
            Response receipt = (Response)packet;
            for (int i = 0; i < this.receiptListeners.size(); ++i) {
                ResponseListener listener = (ResponseListener)this.receiptListeners.get(i);
                if (!listener.onResponse(receipt, out)) continue;
                this.receiptListeners.remove(listener);
                return null;
            }
        }
        if (packet.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)packet;
            Message message = md.getMessage();
            Subscription sub = (Subscription)this.subscriptionsByConsumerId.get(md.getConsumerId());
            if (sub != null) {
                sub.receive(md, out);
            }
        }
        return null;
    }

    private void flushPendingFrames(DataOutput out) throws IOException {
        boolean interrupted = false;
        do {
            try {
                byte[] frame = (byte[])this.pendingWriteFrames.poll(0L, TimeUnit.MILLISECONDS);
                if (frame == null) {
                    return;
                }
                out.write(frame);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
    }

    private void sendError(final String message) {
        AsyncHelper.tryUntilNotInterrupted(new AsyncHelper.Helper(){

            public void cycle() throws InterruptedException {
                StompWireFormat.this.pendingWriteFrames.put((Object)new FrameBuilder("ERROR").addHeader("message", message).toFrame());
            }
        });
    }

    public void onFullyConnected() {
        this.connected = true;
    }

    public void addToPendingReadCommands(final Command info) {
        AsyncHelper.tryUntilNotInterrupted(new AsyncHelper.Helper(){

            public void cycle() throws InterruptedException {
                StompWireFormat.this.pendingReadCommands.put((Object)info);
            }
        });
    }

    void clearTransactionId(String user_tx_id) {
        this.transactions.remove(user_tx_id);
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public ProducerId getProducerId() {
        return this.producerId;
    }

    public Subscription getSubcription(ConsumerId consumerId) {
        return (Subscription)this.subscriptionsByConsumerId.get(consumerId);
    }

    public Set getSubcriptions(ActiveMQDestination destination) {
        return this.subscriptionsByDestination.get(destination);
    }

    public Subscription getSubcription(String name) {
        return (Subscription)this.subscriptionsByName.get(name);
    }

    public void addSubscription(Subscription s) {
        if (s.getSubscriptionId() != null && this.subscriptionsByName.containsKey(s.getSubscriptionId())) {
            Subscription old = (Subscription)this.subscriptionsByName.get(s.getSubscriptionId());
            this.removeSubscription(old);
            this.enqueueCommand(old.close());
        }
        if (s.getSubscriptionId() != null) {
            this.subscriptionsByName.put(s.getSubscriptionId(), s);
        }
        this.subscriptionsByConsumerId.put(s.getConsumerInfo().getConsumerId(), s);
        this.subscriptionsByDestination.put(s.getConsumerInfo().getDestination(), s);
    }

    public void removeSubscription(Subscription s) {
        if (s.getSubscriptionId() != null) {
            this.subscriptionsByName.remove(s.getSubscriptionId());
        }
        this.subscriptionsByConsumerId.remove(s.getConsumerInfo().getConsumerId());
        this.subscriptionsByDestination.remove(s.getConsumerInfo().getDestination(), s);
    }

    public void enqueueCommand(final Command ack) {
        AsyncHelper.tryUntilNotInterrupted(new AsyncHelper.Helper(){

            public void cycle() throws InterruptedException {
                StompWireFormat.this.pendingReadCommands.put((Object)ack);
            }
        });
    }

    public TransactionId getTransactionId(String key) {
        return (TransactionId)this.transactions.get(key);
    }

    public TransactionId registerTransactionId(String user_tx_id, int tx_id) {
        LocalTransactionId transactionId = new LocalTransactionId(this.getConnectionId(), tx_id);
        this.transactions.put(user_tx_id, transactionId);
        return transactionId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public static synchronized int generateTransactionId() {
        return ++transactionIdCounter;
    }

    public ConsumerId createConsumerId() {
        return new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
    }

    public MessageId createMessageId() {
        return new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId());
    }

    public synchronized short generateCommandId() {
        short s = this.lastCommandId;
        this.lastCommandId = (short)(s + 1);
        return s;
    }

    public SessionId generateSessionId() {
        throw new RuntimeException("TODO!!");
    }

    public Packet marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        this.marshal(command, dos);
        dos.close();
        return new ByteArrayPacket(baos.toByteSequence());
    }

    public Object unmarshal(Packet packet) throws IOException {
        PacketInputStream stream = new PacketInputStream(packet);
        DataInputStream dis = new DataInputStream((InputStream)stream);
        return this.unmarshal(dis);
    }

    public void marshal(Object command, DataOutputStream os) throws IOException {
        try {
            this.writeCommand((Command)command, os);
        }
        catch (IOException e) {
            throw e;
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    public Object unmarshal(DataInputStream is) throws IOException {
        try {
            return this.readCommand(is);
        }
        catch (IOException e) {
            throw e;
        }
        catch (JMSException e) {
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    public Map getDispachedMap() {
        return this.dispachedMap;
    }

    static {
        $assertionsDisabled = !StompWireFormat.class.desiredAssertionStatus();
        connectionIdGenerator = new IdGenerator();
    }
}

