/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.transport.stomp.FrameBuilder;
import org.apache.activemq.transport.stomp.StompWireFormat;

public class Subscription {
    public static final int AUTO_ACK = 1;
    public static final int CLIENT_ACK = 2;
    public static final String NO_ID = "~~ NO SUCH THING ~~%%@#!Q";
    private ActiveMQDestination destination;
    private int ackMode = 1;
    private StompWireFormat format;
    private final String subscriptionId;
    private final ConsumerInfo consumerInfo;
    private final LinkedList dispatchedMessages = new LinkedList();

    public Subscription(StompWireFormat format, String subscriptionId, ConsumerInfo consumerInfo) {
        this.format = format;
        this.subscriptionId = subscriptionId;
        this.consumerInfo = consumerInfo;
    }

    void setDestination(ActiveMQDestination actual_dest) {
        this.destination = actual_dest;
    }

    void receive(MessageDispatch md, DataOutput out) throws IOException, JMSException {
        ActiveMQMessage m = (ActiveMQMessage)md.getMessage();
        if (this.ackMode == 2) {
            Subscription sub = this.format.getSubcription(md.getConsumerId());
            sub.addMessageDispatch(md);
            this.format.getDispachedMap().put(m.getJMSMessageID(), sub);
        } else if (this.ackMode == 1) {
            MessageAck ack = new MessageAck(md, 2, 1);
            this.format.enqueueCommand(ack);
        }
        FrameBuilder builder = new FrameBuilder("MESSAGE");
        builder.addHeaders(m);
        if (m.getDataStructureType() == 28) {
            ActiveMQTextMessage msg = (ActiveMQTextMessage)m.copy();
            builder.setBody(msg.getText().getBytes("UTF-8"));
        } else if (m.getDataStructureType() == 24) {
            ActiveMQBytesMessage msg = (ActiveMQBytesMessage)m.copy();
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            builder.addHeader("content-length", data.length);
            builder.setBody(data);
        }
        if (this.subscriptionId != null) {
            builder.addHeader("subscription", this.subscriptionId);
        }
        out.write(builder.toFrame());
    }

    private synchronized void addMessageDispatch(MessageDispatch md) {
        this.dispatchedMessages.addLast(md);
    }

    ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setAckMode(int clientAck) {
        this.ackMode = clientAck;
    }

    public RemoveInfo close() {
        return new RemoveInfo(this.consumerInfo.getConsumerId());
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public synchronized MessageAck createMessageAck(String message_id) {
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setAckType((byte)2);
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        int count = 0;
        Iterator iter = this.dispatchedMessages.iterator();
        while (iter.hasNext()) {
            MessageDispatch md = (MessageDispatch)iter.next();
            String id = ((ActiveMQMessage)md.getMessage()).getJMSMessageID();
            if (ack.getFirstMessageId() == null) {
                ack.setFirstMessageId(md.getMessage().getMessageId());
            }
            this.format.getDispachedMap().remove(id);
            iter.remove();
            ++count;
            if (!id.equals(message_id)) continue;
            ack.setLastMessageId(md.getMessage().getMessageId());
            break;
        }
        ack.setMessageCount(count);
        return ack;
    }
}

