/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.DestinationNamer;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.stomp.Subscription;

public class Unsubscribe
implements StompCommand {
    private static final HeaderParser parser = new HeaderParser();
    private final StompWireFormat format;

    Unsubscribe(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        while (in.readByte() == 0) {
        }
        String subscriptionId = headers.getProperty("id");
        String destination = headers.getProperty("destination");
        if (subscriptionId != null) {
            Subscription s = this.format.getSubcription(subscriptionId);
            this.format.removeSubscription(s);
            return new CommandEnvelope(s.close(), headers);
        }
        ActiveMQDestination d = DestinationNamer.convert(destination);
        Set subs = this.format.getSubcriptions(d);
        Iterator iter = subs.iterator();
        if (iter.hasNext()) {
            Subscription s = (Subscription)iter.next();
            this.format.removeSubscription(s);
            return new CommandEnvelope(s.close(), headers);
        }
        throw new ProtocolException("Unexpected UNSUBSCRIBE received.");
    }
}

