/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.activeio.command.WireFormat;
import org.apache.activemq.Service;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportThreadSupport;
import org.apache.activemq.transport.tcp.TcpBufferedInputStream;
import org.apache.activemq.transport.tcp.TcpBufferedOutputStream;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransport
extends TransportThreadSupport
implements Transport,
Service,
Runnable {
    private static final Log log = LogFactory.getLog((Class)TcpTransport.class);
    private int connectionTimeout = 30000;
    private int soTimeout = 0;
    private int socketBufferSize = 131072;
    private Socket socket;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;
    private WireFormat wireFormat;
    private boolean trace;
    private boolean useLocalHost = true;
    private int minmumWireFormatVersion;
    private InetSocketAddress socketAddress;
    private Map socketOptions;

    protected TcpTransport(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public TcpTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation) throws UnknownHostException, IOException {
        this(wireFormat);
        this.socket = this.createSocket(socketFactory, remoteLocation);
    }

    public TcpTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        this(wireFormat);
        this.socket = this.createSocket(socketFactory, remoteLocation, localLocation);
    }

    public TcpTransport(WireFormat wireFormat, Socket socket) throws IOException {
        this(wireFormat);
        this.socket = socket;
        this.setDaemon(true);
    }

    public void oneway(Command command) throws IOException {
        this.checkStarted(command);
        this.wireFormat.marshal((Object)command, this.dataOut);
        this.dataOut.flush();
    }

    public String toString() {
        return "tcp://" + this.socket.getInetAddress() + ":" + this.socket.getPort();
    }

    public void run() {
        log.trace((Object)"TCP consumer thread starting");
        while (!this.isStopped()) {
            try {
                Command command = (Command)this.wireFormat.unmarshal(this.dataIn);
                this.doConsume(command);
            }
            catch (SocketTimeoutException e) {
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                try {
                    this.stop();
                }
                catch (Exception e2) {
                    log.warn((Object)("Caught while closing: " + e2 + ". Now Closed"), (Throwable)e2);
                }
                this.onException(e);
            }
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public int getMinmumWireFormatVersion() {
        return this.minmumWireFormatVersion;
    }

    public void setMinmumWireFormatVersion(int minmumWireFormatVersion) {
        this.minmumWireFormatVersion = minmumWireFormatVersion;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected Socket createSocket(SocketFactory socketFactory, URI remoteLocation) throws UnknownHostException, IOException {
        String host = this.resolveHostName(remoteLocation.getHost());
        this.socketAddress = new InetSocketAddress(host, remoteLocation.getPort());
        Socket sock = socketFactory.createSocket();
        return sock;
    }

    protected Socket createSocket(SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws IOException, UnknownHostException {
        String host = this.resolveHostName(remoteLocation.getHost());
        InetSocketAddress sockAddress = new InetSocketAddress(host, remoteLocation.getPort());
        InetSocketAddress localAddress = new InetSocketAddress(InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
        Socket sock = socketFactory.createSocket();
        this.initialiseSocket(sock);
        sock.bind(localAddress);
        sock.connect(sockAddress);
        return sock;
    }

    protected String resolveHostName(String host) throws UnknownHostException {
        String localName = InetAddress.getLocalHost().getHostName();
        if (localName != null && this.isUseLocalHost() && localName.equals(host)) {
            return "localhost";
        }
        return host;
    }

    protected void initialiseSocket(Socket sock) throws SocketException {
        try {
            sock.setReceiveBufferSize(this.socketBufferSize);
            sock.setSendBufferSize(this.socketBufferSize);
        }
        catch (SocketException se) {
            log.warn((Object)("Cannot set socket buffer size = " + this.socketBufferSize), (Throwable)se);
        }
        sock.setSoTimeout(this.soTimeout);
    }

    protected void doStart() throws Exception {
        this.initialiseSocket(this.socket);
        if (this.socketAddress != null) {
            if (this.connectionTimeout >= 0) {
                this.socket.connect(this.socketAddress, this.connectionTimeout);
            } else {
                this.socket.connect(this.socketAddress);
            }
        }
        this.initializeStreams();
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.closeStreams();
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void initializeStreams() throws IOException {
        TcpBufferedInputStream buffIn = new TcpBufferedInputStream(this.socket.getInputStream(), 8192);
        this.dataIn = new DataInputStream(buffIn);
        TcpBufferedOutputStream buffOut = new TcpBufferedOutputStream(this.socket.getOutputStream(), 16384);
        this.dataOut = new DataOutputStream(buffOut);
    }

    protected void closeStreams() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
        }
        if (this.dataIn != null) {
            this.dataIn.close();
        }
    }

    public void setSocketOptions(Map socketOptions) {
        IntrospectionSupport.setProperties(this.socket, socketOptions);
    }
}

