/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.MarshallingTransportFilter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.vm.VMTransport;
import org.apache.activemq.transport.vm.VMTransportServer;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMTransportFactory
extends TransportFactory {
    private static final Log log = LogFactory.getLog((Class)VMTransportFactory.class);
    public static final ConcurrentHashMap brokers = new ConcurrentHashMap();
    public static final ConcurrentHashMap connectors = new ConcurrentHashMap();
    public static final ConcurrentHashMap servers = new ConcurrentHashMap();
    BrokerFactory.BrokerFactoryHandler brokerFactoryHandler;

    public Transport doConnect(URI location) throws Exception {
        return VMTransportServer.configure(this.doCompositeConnect(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport doCompositeConnect(URI location) throws Exception {
        Map options;
        String host;
        URI brokerURI;
        URISupport.CompositeData data = URISupport.parseComposite(location);
        if (data.getComponents().length == 1 && "broker".equals(data.getComponents()[0].getScheme())) {
            brokerURI = data.getComponents()[0];
            URISupport.CompositeData brokerData = URISupport.parseComposite(brokerURI);
            host = (String)brokerData.getParameters().get("brokerName");
            if (host == null) {
                host = "localhost";
            }
            if (brokerData.getPath() != null) {
                host = data.getPath();
            }
            options = data.getParameters();
            location = new URI("vm://" + host);
        } else {
            try {
                host = location.getHost();
                options = URISupport.parseParamters(location);
                String config = (String)options.remove("brokerConfig");
                if (config != null) {
                    brokerURI = new URI(config);
                } else {
                    Map brokerOptions = IntrospectionSupport.extractProperties(options, "broker.");
                    brokerURI = new URI("broker://()/" + host + "?" + URISupport.createQueryString(brokerOptions));
                }
            }
            catch (URISyntaxException e1) {
                throw IOExceptionSupport.create(e1);
            }
            location = new URI("vm://" + host);
        }
        if (host == null) {
            host = "localhost";
        }
        VMTransportServer server = (VMTransportServer)servers.get((Object)host);
        if (!this.validateBroker(host) || server == null) {
            BrokerService broker = null;
            Object object = BrokerRegistry.getInstance().getRegistryMutext();
            synchronized (object) {
                broker = BrokerRegistry.getInstance().lookup(host);
                if (broker == null) {
                    try {
                        broker = this.brokerFactoryHandler != null ? this.brokerFactoryHandler.createBroker(brokerURI) : BrokerFactory.createBroker(brokerURI);
                        broker.start();
                    }
                    catch (URISyntaxException e) {
                        throw IOExceptionSupport.create(e);
                    }
                    brokers.put((Object)host, (Object)broker);
                }
                if ((server = (VMTransportServer)servers.get((Object)host)) == null) {
                    server = (VMTransportServer)this.bind(location, true);
                    TransportConnector connector = new TransportConnector(broker.getBroker(), server);
                    connector.setUri(location);
                    connector.setTaskRunnerFactory(broker.getTaskRunnerFactory());
                    connector.start();
                    connectors.put((Object)host, (Object)connector);
                }
            }
        }
        VMTransport vmtransport = server.connect();
        IntrospectionSupport.setProperties(vmtransport, options);
        Transport transport = vmtransport;
        if (vmtransport.isMarshal()) {
            HashMap optionsCopy = new HashMap(options);
            transport = new MarshallingTransportFilter(transport, this.createWireFormat(options), this.createWireFormat(optionsCopy));
        }
        if (!options.isEmpty()) {
            throw new IllegalArgumentException("Invalid connect parameters: " + options);
        }
        return transport;
    }

    public TransportServer doBind(String brokerId, URI location) throws IOException {
        return this.bind(location, false);
    }

    private TransportServer bind(URI location, boolean dispose) throws IOException {
        String host = location.getHost();
        log.info((Object)("binding to broker: " + host));
        VMTransportServer server = new VMTransportServer(location, dispose);
        Object currentBoundValue = servers.get((Object)host);
        if (currentBoundValue != null) {
            throw new IOException("VMTransportServer already bound at: " + location);
        }
        servers.put((Object)host, (Object)server);
        return server;
    }

    public static void stopped(VMTransportServer server) {
        String host = server.getBindURI().getHost();
        log.info((Object)("Shutting down VM connectors for broker: " + host));
        servers.remove((Object)host);
        TransportConnector connector = (TransportConnector)connectors.remove((Object)host);
        if (connector != null) {
            ServiceSupport.dispose(connector);
            BrokerService broker = (BrokerService)brokers.remove((Object)host);
            if (broker != null) {
                ServiceSupport.dispose(broker);
            }
        }
    }

    public static void stopped(String host) {
        log.info((Object)("Shutting down VM connectors for broker: " + host));
        servers.remove((Object)host);
        TransportConnector connector = (TransportConnector)connectors.remove((Object)host);
        if (connector != null) {
            ServiceSupport.dispose(connector);
            BrokerService broker = (BrokerService)brokers.remove((Object)host);
            if (broker != null) {
                ServiceSupport.dispose(broker);
            }
        }
    }

    public BrokerFactory.BrokerFactoryHandler getBrokerFactoryHandler() {
        return this.brokerFactoryHandler;
    }

    public void setBrokerFactoryHandler(BrokerFactory.BrokerFactoryHandler brokerFactoryHandler) {
        this.brokerFactoryHandler = brokerFactoryHandler;
    }

    private boolean validateBroker(String host) {
        boolean result = true;
        if (brokers.containsKey((Object)host) || servers.containsKey((Object)host) || connectors.containsKey((Object)host)) {
            TransportConnector connector = (TransportConnector)connectors.get((Object)host);
            if (BrokerRegistry.getInstance().lookup(host) == null || connector != null && connector.getBroker().isStopped()) {
                result = false;
                brokers.remove((Object)host);
                servers.remove((Object)host);
                if (connector != null) {
                    connectors.remove((Object)host);
                    if (connector != null) {
                        ServiceSupport.dispose(connector);
                    }
                }
            }
        }
        return result;
    }
}

