/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.activeio.adapter.AsyncToSyncChannelFactory;
import org.apache.activeio.adapter.SyncToAsyncChannelFactory;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelFactory;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.util.FactoryFinder;

public class ChannelFactory
implements SyncChannelFactory,
AsyncChannelFactory {
    private final HashMap syncChannelFactoryMap = new HashMap();
    private final HashMap asyncChannelFactoryMap = new HashMap();
    public static final Executor DEFAULT_EXECUTOR = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue());
    private static FactoryFinder finder;

    public SyncChannel openSyncChannel(URI location) throws IOException {
        SyncChannelFactory factory = this.getSynchChannelFactory(location.getScheme());
        return factory.openSyncChannel(location);
    }

    public SyncChannelServer bindSyncChannel(URI location) throws IOException {
        SyncChannelFactory factory = this.getSynchChannelFactory(location.getScheme());
        return factory.bindSyncChannel(location);
    }

    public AsyncChannel openAsyncChannel(URI location) throws IOException {
        AsyncChannelFactory factory = this.getAsyncChannelFactory(location.getScheme());
        return factory.openAsyncChannel(location);
    }

    public AsyncChannelServer bindAsyncChannel(URI location) throws IOException {
        AsyncChannelFactory factory = this.getAsyncChannelFactory(location.getScheme());
        return factory.bindAsyncChannel(location);
    }

    private SyncChannelFactory getSynchChannelFactory(String protocol) throws IOException {
        try {
            SyncChannelFactory rc = (SyncChannelFactory)this.syncChannelFactoryMap.get(protocol);
            if (rc == null) {
                try {
                    rc = (SyncChannelFactory)finder.newInstance(protocol, "SyncChannelFactory.");
                }
                catch (Throwable original) {
                    try {
                        AsyncChannelFactory f = (AsyncChannelFactory)finder.newInstance(protocol, "AsyncChannelFactory.");
                        rc = AsyncToSyncChannelFactory.adapt(f);
                    }
                    catch (Throwable e) {
                        throw original;
                    }
                }
                this.syncChannelFactoryMap.put(protocol, rc);
            }
            return rc;
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not load a SyncChannelFactory for protcol: " + protocol + ", reason: " + e).initCause(e);
        }
    }

    private AsyncChannelFactory getAsyncChannelFactory(String protocol) throws IOException {
        try {
            AsyncChannelFactory rc = (AsyncChannelFactory)this.asyncChannelFactoryMap.get(protocol);
            if (rc == null) {
                try {
                    rc = (AsyncChannelFactory)finder.newInstance(protocol, "AsyncChannelFactory.");
                }
                catch (Throwable original) {
                    try {
                        SyncChannelFactory f = (SyncChannelFactory)finder.newInstance(protocol, "SyncChannelFactory.");
                        rc = SyncToAsyncChannelFactory.adapt(f);
                    }
                    catch (Throwable e) {
                        throw original;
                    }
                }
                this.asyncChannelFactoryMap.put(protocol, rc);
            }
            return rc;
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not load a AsyncChannelFactory for protcol: " + protocol + ", reason: " + e).initCause(e);
        }
    }

    static {
        ((ThreadPoolExecutor)DEFAULT_EXECUTOR).setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setDaemon(true);
                return thread;
            }
        });
        finder = new FactoryFinder("META-INF/services/org/apache/activeio/channel/");
    }
}

